/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker;

import java.io.File;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.iqtig.packer.shared.error.crypto.CryptoException;
import org.iqtig.xpacker.Configuration;
import org.iqtig.xpacker.config.ConfigurationImpl;
import org.iqtig.xpacker.impl.KeyModulusGetter;
import org.iqtig.xpacker.impl.XPacker;
import org.iqtig.xpacker.impl.keyverifier.KeyChecker;
import org.xml.sax.SAXException;

public class Api {
    private static final String ENCRYPTION = "encryption";

    private Api() {
    }

    public static void encrypt(File xmlInFileName, File xmlOufFileName, File keyfileName, List<String> tags, String encryptedKeyTag) throws InvalidKeyException, Base64DecodingException, Exception {
        Api.encrypt(xmlInFileName, xmlOufFileName, keyfileName, null, null, tags, encryptedKeyTag);
    }

    public static void encrypt(File xmlInFileName, File xmlOufFileName, File keyfileName, List<String> tags) throws InvalidKeyException, Base64DecodingException, Exception {
        Api.encrypt(xmlInFileName, xmlOufFileName, keyfileName, null, null, tags, ENCRYPTION);
    }

    public static void encrypt(File xmlInFileName, File xmlOufFileName, PublicKey publicKey, String publicKeyId, List<String> tags) throws InvalidKeyException, Base64DecodingException, Exception {
        Api.encrypt(xmlInFileName, xmlOufFileName, null, publicKey, publicKeyId, tags, ENCRYPTION);
    }

    public static void encrypt(File xmlInFileName, File xmlOufFileName, PublicKey publicKey, String publicKeyId, List<String> tags, String encryptedKeyTag) throws InvalidKeyException, Base64DecodingException, Exception {
        Api.encrypt(xmlInFileName, xmlOufFileName, null, publicKey, publicKeyId, tags, encryptedKeyTag);
    }

    private static void encrypt(File xmlInFileName, File xmlOufFileName, File keyfileName, PublicKey publicKey, String publicKeyId, List<String> tags, String encryptedKeyTag) throws InvalidKeyException, Base64DecodingException, Exception {
        List<String> keyFilenames = keyfileName != null ? Arrays.asList(keyfileName.getAbsolutePath()) : Collections.emptyList();
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().xmlInFileName(xmlInFileName.getAbsolutePath()).xmlOuFileName(xmlOufFileName.getAbsolutePath()).keyNames(keyFilenames).publicKey(publicKey).publicKeyId(publicKeyId).tag(tags).encryptedKeyTag(encryptedKeyTag).stat(ConfigurationImpl.Stat.ENCRYPT).build();
        new XPacker().running(configuration);
    }

    public static void decrypt(File xmlInFileName, File xmlOufFileName, File keyfileName, List<String> tags, String encryptedKeyTag) throws InvalidKeyException, Base64DecodingException, Exception {
        Api.decrypt(xmlInFileName, xmlOufFileName, keyfileName, null, tags, encryptedKeyTag);
    }

    public static void decrypt(File xmlInFileName, File xmlOufFileName, File keyfileName, List<String> tags) throws InvalidKeyException, Base64DecodingException, Exception {
        Api.decrypt(xmlInFileName, xmlOufFileName, keyfileName, null, tags, ENCRYPTION);
    }

    public static void decrypt(File xmlInFileName, File xmlOufFileName, PrivateKey privateKey, List<String> tags) throws InvalidKeyException, Base64DecodingException, Exception {
        Api.decrypt(xmlInFileName, xmlOufFileName, null, privateKey, tags, ENCRYPTION);
    }

    public static void decrypt(File xmlInFileName, File xmlOufFileName, PrivateKey privateKey, List<String> tags, String encryptedKeyTag) throws InvalidKeyException, Base64DecodingException, Exception {
        Api.decrypt(xmlInFileName, xmlOufFileName, null, privateKey, tags, encryptedKeyTag);
    }

    private static void decrypt(File xmlInFileName, File xmlOufFileName, File keyfileName, PrivateKey privateKey, List<String> tags, String encryptedKeyTag) throws InvalidKeyException, Base64DecodingException, Exception {
        List<String> keyFilenames = keyfileName != null ? Arrays.asList(keyfileName.getAbsolutePath()) : Collections.emptyList();
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().xmlInFileName(xmlInFileName.getAbsolutePath()).xmlOuFileName(xmlOufFileName.getAbsolutePath()).keyNames(keyFilenames).tag(tags).encryptedKeyTag(encryptedKeyTag).stat(ConfigurationImpl.Stat.DECRYPT).privateKey(privateKey).build();
        new XPacker().running(configuration);
    }

    public static void keygen(File keyFilename) throws InvalidKeyException, Base64DecodingException, Exception {
        List<String> keyFilenames = Arrays.asList(keyFilename.getAbsolutePath());
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().xmlInFileName(null).xmlOuFileName(null).keyNames(keyFilenames).tag(null).encryptedKeyTag(null).stat(ConfigurationImpl.Stat.GENKEY).build();
        new XPacker().running(configuration);
    }

    public static String getModulus(File publicKeyFile) throws CryptoException {
        KeyModulusGetter modulusGetter = new KeyModulusGetter(publicKeyFile);
        return modulusGetter.getModulus();
    }

    public static boolean keyHasBeenUsedForTagEncryption(File xmlFile, File publicKeyFile, String tag) throws CryptoException, XMLSecurityException, SAXException {
        KeyChecker keyChecker = new KeyChecker(xmlFile, publicKeyFile, tag);
        return keyChecker.keyHasBeenUsedForTagEncryption();
    }
}

