/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.core.impl.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;
import org.iqtig.tpacker.core.impl.io.FileInputStreamContainer;
import org.iqtig.tpacker.core.impl.io.InputIOProvider;

public class EncryptionTypeChecker {
    private final List<FileInputStreamContainer> fileContainer;

    public EncryptionTypeChecker(InputIOProvider input) {
        this.fileContainer = input.getFileInputStreamContainer();
    }

    public List<EncTypeContainer> checkEncryptionTypes() {
        ArrayList<EncTypeContainer> result = new ArrayList<EncTypeContainer>();
        for (FileInputStreamContainer fileCont : this.fileContainer) {
            EncTypeContainer encTypeContainer = new EncTypeContainer();
            encTypeContainer.fileContainer = fileCont;
            encTypeContainer.type = this.checkEncryptionType(fileCont);
            result.add(encTypeContainer);
        }
        return result;
    }

    private CryptographySupportShared.EncryptionType checkEncryptionType(FileInputStreamContainer fileCont) {
        CryptographySupportShared.EncryptionType encryptionType;
        block8: {
            CryptographySupportShared cryptographySupport = new CryptographySupportShared();
            InputStream inputStream = fileCont.getInputStream();
            try {
                encryptionType = cryptographySupport.checkEncryptionType(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Beim Schlie\u00dfen des Files '" + fileCont.getName() + "' trat eine IOException auf.", e);
                }
            }
            inputStream.close();
        }
        return encryptionType;
    }

    public static class EncTypeContainer {
        public FileInputStreamContainer fileContainer;
        public CryptographySupportShared.EncryptionType type;
    }
}

