/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.impl;

import java.util.List;
import org.iqtig.tpacker.core.impl.crypto.EncryptionTypeChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncTypePrinter {
    List<EncryptionTypeChecker.EncTypeContainer> encTypeContainer;
    private static final Logger LOGGER = LoggerFactory.getLogger("SYSTEM_OUT");
    private static final int MAX_PATH_LENGTH = 32;
    private static final String TABLE_BOUNDARY = "+-----------------------------------------------------------+";

    public EncTypePrinter(List<EncryptionTypeChecker.EncTypeContainer> encTypeContainer) {
        this.encTypeContainer = encTypeContainer;
    }

    public void printOutEncryptionTypes() {
        LOGGER.info(TABLE_BOUNDARY);
        LOGGER.info("| Datei                              | Verschluesselungsart |");
        LOGGER.info(TABLE_BOUNDARY);
        for (EncryptionTypeChecker.EncTypeContainer encTypeCont : this.encTypeContainer) {
            LOGGER.info(String.format("| %-35s| %-21s|", this.getShortenedFilePath(encTypeCont), encTypeCont.type.toString()));
        }
        LOGGER.info(TABLE_BOUNDARY);
    }

    private String getShortenedFilePath(EncryptionTypeChecker.EncTypeContainer encContainer) {
        int length = encContainer.fileContainer.getName().length();
        Object result = encContainer.fileContainer.getName();
        if (length > 32) {
            String shortenedFilePath = encContainer.fileContainer.getName().substring(length - 32);
            result = "..." + shortenedFilePath;
        }
        return result;
    }
}

