/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.iqtig.tpacker.cli.Configuration;

public class ConfigHelper {
    private static final String CRYPT_SUFIX = ".aes";
    private static final String ZIP_SUFIX = ".zip";
    private static final String TIME_STAMP = "yyyy_MM_dd_HHmmss";
    private final Configuration configuration;
    private boolean timeStamp;

    ConfigHelper(Configuration configuration) {
        this.configuration = configuration;
        this.timeStamp = configuration.isTimeStamp();
    }

    public String fileOnly(String name) {
        String newname = ConfigHelper.removePath(name, "/");
        newname = ConfigHelper.removePath(newname, "\\");
        return newname;
    }

    public String generateFileSufix() {
        Object filename = "";
        if (!this.timeStamp) {
            filename = (String)filename + "-" + new SimpleDateFormat(TIME_STAMP).format(new Date());
        }
        if (this.configuration.isZip()) {
            filename = (String)filename + ZIP_SUFIX;
        }
        if (this.configuration.isEncypt() || this.configuration.isHybridEncrypt()) {
            filename = (String)filename + CRYPT_SUFIX;
        }
        return filename;
    }

    private static String removePath(String name, String toTest) {
        String newname = name;
        if (name.contains(toTest)) {
            newname = name.substring(name.lastIndexOf(toTest) + 1);
        }
        return newname;
    }

    public void setTimeStamp(boolean timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean isInFiles() {
        return this.configuration.getInFiles() != null;
    }

    public boolean isPassword() {
        return this.configuration.getPassword() != null;
    }
}

