/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.shared.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class NumberByteArray {
    private final byte[] internalArray;

    public NumberByteArray(byte[] byteArray) {
        Objects.requireNonNull(byteArray, "NumberByteArray kann nicht mit 'null' initialisiert werden.");
        this.internalArray = byteArray;
    }

    public NumberByteArray(BigInteger number) {
        Objects.requireNonNull(number, "NumberByteArray kann nicht mit 'null' initialisiert werden.");
        this.internalArray = number.toByteArray();
    }

    public byte[] toSignedByteArray() {
        byte[] result = new byte[this.internalArray.length];
        System.arraycopy(this.internalArray, 0, result, 0, result.length);
        return result;
    }

    public byte[] toUnsignedByteArray() {
        int i;
        Objects.requireNonNull(this.internalArray, "Internes Zahlen-Array ist null.");
        for (i = 0; i < this.internalArray.length && this.internalArray[i] == 0; ++i) {
        }
        byte[] result = new byte[this.internalArray.length - i];
        if (i < this.internalArray.length) {
            System.arraycopy(this.internalArray, i, result, 0, result.length);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NumberByteArray other = (NumberByteArray)obj;
        return Arrays.equals(this.internalArray, other.internalArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.internalArray);
    }
}

