/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.swing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class EnablementSwitcher {
    private final List<JComponent> components;
    private final Map<JComponent, Boolean> storedPreviousState;

    public EnablementSwitcher(JComponent ... components) {
        this.components = Arrays.asList(components);
        this.storedPreviousState = new HashMap<JComponent, Boolean>(components.length);
    }

    public void setDisabled() {
        this.storedPreviousState.clear();
        for (JComponent component : this.components) {
            this.storedPreviousState.put(component, component.isEnabled());
            component.setEnabled(false);
        }
    }

    public void returnToPreviousState() {
        for (Map.Entry<JComponent, Boolean> compWithPrevState : this.storedPreviousState.entrySet()) {
            compWithPrevState.getKey().setEnabled(compWithPrevState.getValue());
        }
    }
}

