/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.swing;

import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.iqtig.packer.gui.comp.ObservableModel;
import org.iqtig.packer.gui.swing.TextDocumentBlankAdapter;

public class BiDirectionalTextBinder {
    private final ObservableModel model;
    private final JTextComponent component;
    private final TextDocumentBlankAdapter widgetListener;
    private final PropertyChangeListener modelListener;

    public BiDirectionalTextBinder(String modelPropertyName, final Consumer<String> modelSetter, ObservableModel model, final JTextComponent component) {
        this.model = model;
        this.component = component;
        this.widgetListener = new TextDocumentBlankAdapter(){

            @Override
            public void doJob() {
                String normalizedTextFromWidget = StringUtils.isNotBlank(component.getText()) ? component.getText() : null;
                BiDirectionalTextBinder.this.deactivateModelListener();
                modelSetter.accept(normalizedTextFromWidget);
                BiDirectionalTextBinder.this.activateModelListener();
            }
        };
        this.modelListener = e -> {
            if (modelPropertyName.equals(e.getPropertyName())) {
                this.deactivateWidgetListener();
                component.setText((String)e.getNewValue());
                this.activateWidgetListener();
            }
        };
        this.activateModelListener();
        this.activateWidgetListener();
    }

    private void deactivateModelListener() {
        this.model.removePropertyChangeListener(this.modelListener);
    }

    private void activateModelListener() {
        this.model.addPropertyChangeListener(this.modelListener);
    }

    private void deactivateWidgetListener() {
        this.component.getDocument().removeDocumentListener(this.widgetListener);
    }

    private void activateWidgetListener() {
        this.component.getDocument().addDocumentListener(this.widgetListener);
    }
}

