/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.swing;

import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;
import org.iqtig.packer.gui.comp.ObservableModel;

public class BiDirectionalCheckBoxBinder {
    private final ObservableModel model;
    private final JCheckBox component;
    private final ChangeListener widgetListener;
    private final PropertyChangeListener modelListener;

    public BiDirectionalCheckBoxBinder(String modelPropertyName, Consumer<Boolean> modelSetter, ObservableModel model, JCheckBox component) {
        this.model = model;
        this.component = component;
        this.widgetListener = e -> {
            this.deactivateModelListener();
            modelSetter.accept(component.isSelected());
            this.activateModelListener();
        };
        this.modelListener = e -> {
            if (modelPropertyName.equals(e.getPropertyName())) {
                this.deactivateWidgetListener();
                component.setSelected((Boolean)e.getNewValue());
                this.activateWidgetListener();
            }
        };
        this.activateModelListener();
        this.activateWidgetListener();
    }

    private void deactivateModelListener() {
        this.model.removePropertyChangeListener(this.modelListener);
    }

    private void activateModelListener() {
        this.model.addPropertyChangeListener(this.modelListener);
    }

    private void deactivateWidgetListener() {
        this.component.removeChangeListener(this.widgetListener);
    }

    private void activateWidgetListener() {
        this.component.addChangeListener(this.widgetListener);
    }
}

