/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.keymanagement.keystore.impl;

import java.io.File;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.iqtig.packer.gui.constants.KeyfileType;
import org.iqtig.packer.gui.keymanagement.KeyContainer;
import org.iqtig.packer.gui.keymanagement.KeyList;
import org.iqtig.packer.gui.keymanagement.PublicKeyContainer;
import org.iqtig.packer.gui.keymanagement.keystore.KeystoreInitData;
import org.iqtig.packer.gui.keymanagement.keystore.PublicKeystore;
import org.iqtig.packer.gui.keymanagement.keystore.impl.PublicKeystoreImplHelper;
import org.iqtig.packer.gui.keymanagement.keystore.output.DefaultResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.InitResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeylistOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeylistResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeystoreOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.PersistentUniInitResult;

public class PublicKeystoreImpl
implements PublicKeystore {
    private boolean active = true;
    Preferences nodeForPublicKeys;

    @Override
    public KeystoreOutput storeKeyContainer(KeyContainer keyContainer) {
        KeystoreOutput result = new KeystoreOutput();
        try {
            String keyName = keyContainer.getName();
            if (this.getKeynames().contains(keyName)) {
                result.setResult(DefaultResult.FALSE);
                return result;
            }
            Preferences keyNode = this.nodeForPublicKeys.node(keyName);
            keyNode.putByteArray("keyBytes", PublicKeystoreImplHelper.encodeKeyBytes(keyContainer));
            if (keyContainer.getKeyfile() != null) {
                keyNode.put("keyfilePath", keyContainer.getKeyfile().getPath());
            }
            if (keyContainer.getKeyentryAlias() != null) {
                keyNode.put("keyAlias", keyContainer.getKeyentryAlias());
            }
            if (keyContainer.getKeyFileType() != null) {
                keyNode.put("keyfileType", keyContainer.getKeyFileType().toString());
            }
        }
        catch (Exception e) {
            result.setResult(DefaultResult.ERROR);
            result.setException(e);
            return result;
        }
        result.setResult(DefaultResult.TRUE);
        return result;
    }

    @Override
    public KeystoreOutput deleteKeyContainer(KeyContainer keyContainer) {
        return this.deleteKeyContainer(keyContainer.getName());
    }

    @Override
    public KeystoreOutput deleteKeyContainer(String name) {
        KeystoreOutput result = new KeystoreOutput();
        try {
            this.nodeForPublicKeys.node(name).removeNode();
            result.setResult(DefaultResult.TRUE);
        }
        catch (Exception e) {
            result.setResult(DefaultResult.ERROR);
            result.setException(e);
        }
        return result;
    }

    @Override
    public KeylistOutput loadKeyContainer() {
        KeylistOutput result = new KeylistOutput();
        try {
            KeyList<PublicKeyContainer> resultingList = new KeyList<PublicKeyContainer>();
            List<String> keyNames = this.getKeynames();
            for (String keyName : keyNames) {
                File keyFile;
                Preferences keyNode = this.nodeForPublicKeys.node(keyName);
                byte[] keyBytesRaw = keyNode.getByteArray("keyBytes", null);
                String keyFilePath = keyNode.get("keyfilePath", null);
                String keyAlias = keyNode.get("keyAlias", null);
                PublicKey publicKey = PublicKeystoreImplHelper.decodeKeyBytes(keyBytesRaw);
                String fileType = keyNode.get("keyfileType", null);
                KeyfileType keyfileType = null;
                if (fileType != null) {
                    keyfileType = Enum.valueOf(KeyfileType.class, fileType);
                }
                File file = keyFile = keyFilePath != null ? new File(keyFilePath) : null;
                if (publicKey != null) {
                    PublicKeyContainer keyContainer = new PublicKeyContainer.PublicKeyContainerBuilder().publicKey(publicKey).keyfile(keyFile).keyentryAlias(keyAlias).keyName(keyName).keyfileType(keyfileType).build();
                    resultingList.addKey(keyContainer);
                    continue;
                }
                keyNode.removeNode();
            }
            result.setKeyList(resultingList);
            result.setResult(KeylistResult.SUCCESS);
        }
        catch (Exception e) {
            result.setResult(KeylistResult.ERROR);
            result.setThrowable(e);
        }
        return result;
    }

    @Override
    public PersistentUniInitResult initPersistenceUnit(KeystoreInitData initData) {
        PersistentUniInitResult result = new PersistentUniInitResult();
        Preferences prefs = initData.getRootNode();
        if (prefs == null) {
            result.setResult(InitResult.PREF_ERROR);
            this.active = false;
            return result;
        }
        try {
            this.nodeForPublicKeys = initData.getRootNode().node(initData.getSubnodeName());
            result.setResult(InitResult.SUCCESS);
        }
        catch (Exception e) {
            result.setResult(InitResult.ERROR);
            result.setFatalException(e);
        }
        return result;
    }

    @Override
    public KeystoreOutput clearPersistenceUnit() {
        KeystoreOutput result = new KeystoreOutput();
        try {
            this.nodeForPublicKeys.removeNode();
            result.setResult(DefaultResult.TRUE);
        }
        catch (Exception e) {
            result.setResult(DefaultResult.ERROR);
            result.setException(e);
        }
        return result;
    }

    private List<String> getKeynames() {
        try {
            return Arrays.asList(this.nodeForPublicKeys.childrenNames());
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deactivate() {
        this.active = false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

