/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.keymanagement;

import java.io.File;
import java.security.Key;
import java.security.PublicKey;
import org.iqtig.packer.gui.constants.KeyfileType;
import org.iqtig.packer.gui.keymanagement.KeyContainer;
import org.iqtig.packer.shared.keyio.KeyLoader;
import org.iqtig.packer.shared.keyio.KeyLoaderFactory;
import org.iqtig.packer.shared.keyio.output.KeyloadOutput;
import org.iqtig.packer.shared.keyio.output.KeyloadResult;

public class PublicKeyContainer
extends KeyContainer {
    private PublicKey publicKey;

    public PublicKeyContainer(String name, File keyfile) {
        this.keyName = name;
        this.keyfile = keyfile;
        this.keyFileType = KeyfileType.KEYFILE;
    }

    public PublicKeyContainer(String name, File keyfile, String keystorePassword, String keyentryAlias) {
        this.keyName = name;
        this.keyfile = keyfile;
        this.keystorePassword = keystorePassword;
        this.keyentryAlias = keyentryAlias;
        this.keyFileType = KeyfileType.KEYSTORE;
    }

    public PublicKeyContainer(PublicKeyContainerBuilder publicKeyContainerBuilder) {
        this.keyfile = publicKeyContainerBuilder.keyfile;
        this.keystorePassword = publicKeyContainerBuilder.keystorePassword;
        this.keyentryAlias = publicKeyContainerBuilder.keyentryAlias;
        this.keyentryPassword = publicKeyContainerBuilder.keyentryPassword;
        this.keyName = publicKeyContainerBuilder.keyName;
        this.key = publicKeyContainerBuilder.publicKey;
        this.publicKey = publicKeyContainerBuilder.publicKey;
        this.keyFileType = publicKeyContainerBuilder.keyfileType;
        this.init();
    }

    @Override
    public KeyloadOutput loadKey() {
        KeyloadOutput output = null;
        KeyLoader keyLoader = KeyLoaderFactory.getKeyLoader();
        KeyfileType keyfileType = null;
        if (this.keyentryAlias != null) {
            output = keyLoader.loadPublicKeyFromKeystore(this.keyfile.toPath(), this.keystorePassword, this.keyentryAlias);
            keyfileType = KeyfileType.KEYSTORE;
        } else {
            output = keyLoader.loadPublicKeyFromKeyfile(this.keyfile.toPath());
            keyfileType = KeyfileType.KEYFILE;
        }
        if (KeyloadResult.OK.equals((Object)output.getResult())) {
            this.publicKey = (PublicKey)output.getKey();
            this.key = this.publicKey;
            this.keyFileType = keyfileType;
            this.calcHash();
        }
        return output;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Key getKey() {
        return this.publicKey;
    }

    public static class PublicKeyContainerBuilder {
        File keyfile;
        String keystorePassword;
        String keyentryAlias;
        String keyentryPassword;
        String keyName;
        PublicKey publicKey;
        KeyfileType keyfileType;

        public PublicKeyContainerBuilder keyfile(File keyfile) {
            this.keyfile = keyfile;
            return this;
        }

        public PublicKeyContainerBuilder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public PublicKeyContainerBuilder keyentryAlias(String keyentryAlias) {
            this.keyentryAlias = keyentryAlias;
            return this;
        }

        public PublicKeyContainerBuilder keyentryPassword(String keyentryPassword) {
            this.keyentryPassword = keyentryPassword;
            return this;
        }

        public PublicKeyContainerBuilder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public PublicKeyContainerBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public PublicKeyContainerBuilder keyfileType(KeyfileType keyfileType) {
            this.keyfileType = keyfileType;
            return this;
        }

        public PublicKeyContainer build() {
            return new PublicKeyContainer(this);
        }
    }
}

