/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.keymanagement;

import java.io.File;
import java.security.Key;
import java.security.PrivateKey;
import org.iqtig.packer.gui.constants.KeyfileType;
import org.iqtig.packer.gui.keymanagement.KeyContainer;
import org.iqtig.packer.shared.keyio.KeyLoader;
import org.iqtig.packer.shared.keyio.KeyLoaderFactory;
import org.iqtig.packer.shared.keyio.output.KeyloadOutput;
import org.iqtig.packer.shared.keyio.output.KeyloadResult;

public class PrivateKeyContainer
extends KeyContainer {
    private PrivateKey privateKey;

    public PrivateKeyContainer(String name, File keyfile) {
        this.keyName = name;
        this.keyfile = keyfile;
        this.keyFileType = KeyfileType.KEYFILE;
    }

    public PrivateKeyContainer(String name, File keyfile, String keystorePassword, String keyentryAlias, String keyentryPassword) {
        this.keyName = name;
        this.keyfile = keyfile;
        this.keystorePassword = keystorePassword;
        this.keyentryAlias = keyentryAlias;
        this.keyentryPassword = keyentryPassword;
        this.keyFileType = KeyfileType.KEYSTORE;
    }

    public PrivateKeyContainer(PrivateKeyContainerBuilder privateKeyContainerBuilder) {
        this.keyfile = privateKeyContainerBuilder.keyfile;
        this.keystorePassword = privateKeyContainerBuilder.keystorePassword;
        this.keyentryAlias = privateKeyContainerBuilder.keyentryAlias;
        this.keyentryPassword = privateKeyContainerBuilder.keyentryPassword;
        this.keyName = privateKeyContainerBuilder.keyName;
        this.key = privateKeyContainerBuilder.privateKey;
        this.privateKey = privateKeyContainerBuilder.privateKey;
        this.keyFileType = privateKeyContainerBuilder.keyfileType;
        this.init();
    }

    @Override
    public KeyloadOutput loadKey() {
        KeyloadOutput output = null;
        KeyLoader keyLoader = KeyLoaderFactory.getKeyLoader();
        KeyfileType keyfileType = null;
        if (this.keyentryAlias != null) {
            output = keyLoader.loadPrivateKeyFromKeystore(this.keyfile.toPath(), this.keystorePassword, this.keyentryAlias, this.keyentryPassword);
            keyfileType = KeyfileType.KEYSTORE;
        } else {
            output = keyLoader.loadPrivateKeyFromKeyFile(this.keyfile.toPath());
            keyfileType = KeyfileType.KEYFILE;
        }
        if (KeyloadResult.OK.equals((Object)output.getResult())) {
            this.privateKey = (PrivateKey)output.getKey();
            this.key = this.privateKey;
            this.keyFileType = keyfileType;
            this.calcHash();
        }
        return output;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Key getKey() {
        return this.privateKey;
    }

    public static class PrivateKeyContainerBuilder {
        File keyfile;
        String keystorePassword;
        String keyentryAlias;
        String keyentryPassword;
        String keyName;
        PrivateKey privateKey;
        KeyfileType keyfileType;

        public PrivateKeyContainerBuilder keyfile(File keyfile) {
            this.keyfile = keyfile;
            return this;
        }

        public PrivateKeyContainerBuilder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public PrivateKeyContainerBuilder keyentryAlias(String keyentryAlias) {
            this.keyentryAlias = keyentryAlias;
            return this;
        }

        public PrivateKeyContainerBuilder keyentryPassword(String keyentryPassword) {
            this.keyentryPassword = keyentryPassword;
            return this;
        }

        public PrivateKeyContainerBuilder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public PrivateKeyContainerBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public PrivateKeyContainerBuilder keyfileType(KeyfileType keyfileType) {
            this.keyfileType = keyfileType;
            return this;
        }

        public PrivateKeyContainer build() {
            return new PrivateKeyContainer(this);
        }
    }
}

