/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.keymanagement;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.iqtig.packer.gui.keymanagement.KeyAddResult;
import org.iqtig.packer.gui.keymanagement.KeyContainer;

public class KeyList<T extends KeyContainer> {
    private final List<T> keys = new ArrayList<T>();

    public List<String> getNames() {
        return this.keys.stream().map(KeyContainer::getName).collect(Collectors.toList());
    }

    public T getKeyByName(String name) {
        return (T)((KeyContainer)this.keys.stream().filter(key -> key.getName().equals(name)).findFirst().orElse(null));
    }

    public T getKeyByHash(String hash) {
        return (T)((KeyContainer)this.keys.stream().filter(key -> key.getHash().equals(hash)).findFirst().orElse(null));
    }

    public int size() {
        return this.keys.size();
    }

    public KeyAddResult addKey(T keyContainer) {
        if (keyContainer == null) {
            return KeyAddResult.INVALID_KEY;
        }
        if (((KeyContainer)keyContainer).getName() == null) {
            return KeyAddResult.INVALID_KEYNAME;
        }
        if ("".equals(((KeyContainer)keyContainer).getName())) {
            return KeyAddResult.EMPTY_KEYNAME;
        }
        if (this.getKeyByName(((KeyContainer)keyContainer).getName()) != null) {
            return KeyAddResult.DOUBLE_KEYNAME;
        }
        if (this.getKeyByHash(((KeyContainer)keyContainer).getHash()) != null) {
            return KeyAddResult.DOUBLE_KEY;
        }
        this.keys.add(keyContainer);
        return KeyAddResult.OK;
    }

    public void deleteKeyByName(String name) {
        T keyToDelete = this.getKeyByName(name);
        if (keyToDelete != null) {
            this.keys.remove(keyToDelete);
        }
    }

    public static <T extends KeyContainer> KeyList<T> of(KeyList<T> keys) {
        KeyList<T> result = new KeyList<T>();
        result.keys.addAll(keys.keys);
        return result;
    }

    public static <T extends KeyContainer> KeyList<KeyContainer> keyContaionerOf(KeyList<T> keys) {
        KeyList<KeyContainer> result = new KeyList<KeyContainer>();
        result.keys.addAll(keys.keys);
        return result;
    }
}

