/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.job;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.iqtig.packer.gui.GPackerKModeInputValues;
import org.iqtig.packer.gui.GPackerRtWrapper;
import org.iqtig.packer.gui.constants.Action;
import org.iqtig.packer.gui.constants.ProcessingMode;
import org.iqtig.packer.gui.job.CryptoJob;
import org.iqtig.tpacker.cli.Api;

public class TPackerCryptoJob
implements CryptoJob {
    private static final String MSG_WRONG_ACTION_USAGE = "Programmierfehler: Nur Action.Encrypt zul\u00e4ssig. Im Rahmen der Entpackung kann es zu mehreren Dateien kommen.  Aus diesem Grund kann die Transport-Entschl\u00fcsselung nicht im Rahmen EINER CryptoJob-Pipeline abgearbeitet werden. Die korrekte Nutzung ist: a.) Transport-Entschl\u00fcsselung ausf\u00fchren und b.) mit jeder entpackt/entschl\u00fcsselten Datei eine CryptoJob-Pipeline zur Inhaltsentschl\u00fcsselung erstellen und ausf\u00fchren.";
    private static final int WEIGHT_FOR_TRANSPORT_ENCRYPTION = 1;
    private final String password;
    private final Action action;
    private final String zipFileEntryName;
    private final Path targetFilePath;
    private final Consumer<Integer> progressConsumer;
    private final Consumer<String> msgConsumer;
    private final GPackerKModeInputValues kModeInput;
    private final ProcessingMode processingMode;

    public TPackerCryptoJob(String password, Action action, String zipFileEntryName, Consumer<Integer> progressConsumer, Consumer<String> msgConsumer) {
        this(password, action, zipFileEntryName, progressConsumer, msgConsumer, null, null, null);
    }

    public TPackerCryptoJob(String password, Action action, String zipFileEntryName, Consumer<Integer> progressConsumer, Consumer<String> msgConsumer, Path targetFilePath, GPackerKModeInputValues kModeInput, ProcessingMode processingMode) {
        this.password = password;
        this.action = action;
        this.zipFileEntryName = zipFileEntryName;
        this.progressConsumer = progressConsumer;
        this.msgConsumer = msgConsumer;
        this.targetFilePath = targetFilePath;
        this.kModeInput = kModeInput;
        this.processingMode = processingMode;
        if (Action.DECRYPT == action && processingMode == ProcessingMode.PMODE) {
            throw new IllegalArgumentException(MSG_WRONG_ACTION_USAGE);
        }
    }

    @Override
    public File apply(File file) {
        File tempResultFile;
        long startTimeMillis = System.currentTimeMillis();
        boolean pmode = this.processingMode == ProcessingMode.PMODE;
        boolean kmode = this.processingMode == ProcessingMode.KMODE;
        Action actionOverall = pmode ? this.action : this.kModeInput.actionKMode;
        this.msgConsumer.accept(String.format("[BGN] %s: Transportverschl\u00fcsselung", actionOverall.label));
        ArrayList<File> inputFiles = new ArrayList<File>(1);
        try {
            tempResultFile = File.createTempFile("iqtig", "tpacker");
            String tempFileFolderPath = tempResultFile.getParent();
            Path targetPath = Paths.get(tempFileFolderPath, new String[0]).resolve(this.zipFileEntryName);
            Files.copy(file.toPath(), targetPath, StandardCopyOption.REPLACE_EXISTING);
            inputFiles.add(targetPath.toFile());
        }
        catch (IOException e) {
            throw new GPackerRtWrapper(e);
        }
        try {
            if (Action.ENCRYPT == actionOverall && pmode) {
                Api.zipEncrypt(inputFiles, tempResultFile, this.password, false);
            } else if (Action.ENCRYPT == actionOverall && kmode) {
                Api.zipHybridEncrypt(inputFiles, tempResultFile, this.kModeInput.publicKeyKMode, (Boolean)false);
            } else {
                throw new IllegalArgumentException(MSG_WRONG_ACTION_USAGE);
            }
            Path shittyActualResultPath = Paths.get(tempResultFile.getAbsolutePath() + ".zip.aes", new String[0]);
            Files.copy(shittyActualResultPath, tempResultFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new GPackerRtWrapper(e);
        }
        this.msgConsumer.accept(String.format("[END] %s: Transportverschl\u00fcsselung (Dauer=%s sec)", actionOverall.label, this.getDuration(startTimeMillis)));
        try {
            if (this.targetFilePath != null) {
                Files.copy(tempResultFile.toPath(), this.targetFilePath, StandardCopyOption.REPLACE_EXISTING);
                this.msgConsumer.accept("Ausgabedatei erzeugt: " + this.targetFilePath.getFileName().toString());
            }
        }
        catch (IOException e) {
            throw new GPackerRtWrapper(e);
        }
        this.progressConsumer.accept(this.getWeight());
        return tempResultFile;
    }

    @Override
    public int getWeight() {
        int finalFileWriterWeight = this.targetFilePath == null ? 0 : 1;
        return 1 + finalFileWriterWeight;
    }
}

