/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.job;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.iqtig.packer.gui.GPackerKModeInputValues;
import org.iqtig.packer.gui.GPackerRtWrapper;
import org.iqtig.packer.gui.constants.ProcessingMode;
import org.iqtig.packer.gui.job.CryptoJob;
import org.iqtig.tpacker.cli.Api;

public class CryptoJobSupport {
    public int getWeight(Collection<List<CryptoJob>> jobQueues) {
        return jobQueues.stream().map(this::getWeightOneQueue).reduce(Integer::sum).orElseGet(() -> 0);
    }

    public int getWeightOneQueue(Collection<CryptoJob> jobQueue) {
        return jobQueue.stream().map(CryptoJob::getWeight).reduce(Integer::sum).orElseGet(() -> 0);
    }

    public Path tUnzipAusAeFileToFolder(ProcessingMode processingMode, GPackerKModeInputValues kModeInput, Path ausAeZipFilePath, String password) {
        Path tempDirectoryPath;
        boolean pMode = ProcessingMode.PMODE == processingMode;
        boolean kMode = ProcessingMode.KMODE == processingMode;
        ArrayList<File> inputFiles = new ArrayList<File>(1);
        inputFiles.add(ausAeZipFilePath.toFile());
        try {
            tempDirectoryPath = Files.createTempDirectory("iqtigAusAeUnzipPath", new FileAttribute[0]);
            if (pMode) {
                Api.unzipDecrypt(inputFiles, tempDirectoryPath.toFile(), password);
            } else if (kMode) {
                Api.unzipHybridDecrypt(inputFiles, tempDirectoryPath.toFile(), kModeInput.privateKeyKMode);
            }
        }
        catch (IOException e) {
            throw new GPackerRtWrapper(e);
        }
        return tempDirectoryPath;
    }

    public List<File> executeJobQueue(Collection<CryptoJob> jobQueue, File startValue) {
        ArrayList<File> identityStartValue = new ArrayList<File>(1);
        identityStartValue.add(startValue);
        List startValueAndTempFiles = jobQueue.stream().reduce(identityStartValue, (input, job) -> {
            File lastFile = (File)input.get(input.size() - 1);
            File newFile = (File)job.apply(lastFile);
            ArrayList<File> result1 = new ArrayList<File>(input.size() + 1);
            result1.addAll((Collection<File>)input);
            result1.add(newFile);
            return result1;
        }, (left, right) -> {
            ArrayList result12 = new ArrayList(left.size() + right.size());
            result12.addAll(left);
            result12.addAll(right);
            return result12;
        });
        return startValueAndTempFiles.stream().filter(i -> !startValue.equals(i)).collect(Collectors.toList());
    }
}

