/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.job;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.iqtig.packer.gui.GPackerKModeInputValues;
import org.iqtig.packer.gui.constants.Action;
import org.iqtig.packer.gui.constants.ProcessingMode;
import org.iqtig.packer.gui.constants.Tag;
import org.iqtig.packer.gui.job.CryptoJob;
import org.iqtig.packer.gui.job.TPackerCryptoJob;
import org.iqtig.packer.gui.job.XPackerCryptoJob;
import org.iqtig.packer.gui.keymanagement.KeyContainer;

public class CryptoJobQueueBuilder {
    private final Action action;
    private final Path targetFilePath;
    private final Consumer<Integer> progressConsumer;
    private final Consumer<String> msgConsumer;
    private Map<Tag, KeyContainer> keysByTag;
    private GPackerKModeInputValues kModeInput;
    private final ProcessingMode processingMode;
    private Path targetFilePathTransportEncryption;
    private String transportEncryptionPassword;

    public CryptoJobQueueBuilder(ProcessingMode mode, Action action, Path targetFilePath, Consumer<Integer> progressConsumer, Consumer<String> msgConsumer) {
        this.processingMode = mode;
        this.action = action;
        this.targetFilePath = targetFilePath;
        this.progressConsumer = progressConsumer;
        this.msgConsumer = msgConsumer;
    }

    public CryptoJobQueueBuilder withTags(Map<Tag, KeyContainer> keysByTag) {
        this.keysByTag = keysByTag;
        return this;
    }

    public CryptoJobQueueBuilder withTransportEncryption(String password, Path targetFilePathTransportEncryption, GPackerKModeInputValues kModeInput) {
        this.transportEncryptionPassword = password;
        this.targetFilePathTransportEncryption = targetFilePathTransportEncryption;
        this.kModeInput = kModeInput;
        return this;
    }

    public List<CryptoJob> build() {
        boolean kModeTpEnc;
        ArrayList<CryptoJob> jobQueue = new ArrayList<CryptoJob>();
        int counter = 0;
        if (this.processingMode == ProcessingMode.PMODE) {
            for (Map.Entry<Tag, KeyContainer> keysByTagEntry : this.keysByTag.entrySet()) {
                if (++counter == this.keysByTag.size()) {
                    jobQueue.add(new XPackerCryptoJob(null, keysByTagEntry.getValue().getKey(), keysByTagEntry.getValue().getKeyId(), keysByTagEntry.getKey(), this.action, this.progressConsumer, this.msgConsumer, this.targetFilePath));
                    continue;
                }
                jobQueue.add(new XPackerCryptoJob(null, keysByTagEntry.getValue().getKey(), keysByTagEntry.getValue().getKeyId(), keysByTagEntry.getKey(), this.action, this.progressConsumer, this.msgConsumer));
            }
        }
        boolean pModeTpEnc = StringUtils.isNotBlank(this.transportEncryptionPassword) && this.targetFilePathTransportEncryption != null;
        boolean bl = kModeTpEnc = this.processingMode == ProcessingMode.KMODE && this.kModeInput.actionKMode == Action.ENCRYPT;
        if (pModeTpEnc || kModeTpEnc) {
            String zipFileEntryName = this.targetFilePath.getFileName().toString();
            jobQueue.add(new TPackerCryptoJob(this.transportEncryptionPassword, this.action, zipFileEntryName, this.progressConsumer, this.msgConsumer, this.targetFilePathTransportEncryption, this.kModeInput, this.processingMode));
        }
        return jobQueue;
    }
}

