/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.exception;

import java.util.function.Consumer;
import org.iqtig.packer.gui.exception.AbstractGPackerExceptionProcessor;
import org.iqtig.packer.gui.keymanagement.keystore.output.InitResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.PersistentUniInitResult;

public class GPackerPrivKeystoreInitExceptionProcessor
extends AbstractGPackerExceptionProcessor {
    PersistentUniInitResult result;
    Consumer<String> printer;

    public GPackerPrivKeystoreInitExceptionProcessor(PersistentUniInitResult result, Consumer<String> printer) {
        this.result = result;
        this.printer = printer;
    }

    @Override
    public void process() {
        if (this.result.nonFatalErrorOccurred()) {
            this.printer.accept(this.formatStringWithExceptionDetailsForPrinter(this.result.getNonFatalException(), "Bei der Konsistenzpr\u00fcfung des privaten Keystores ist ein Fehler aufgetreten. Er wird zur\u00fcckgesetzt."));
        }
        if (InitResult.ERROR.equals((Object)this.result.getResult()) && this.result.fatalErrorOccurred()) {
            this.printer.accept(this.formatStringWithExceptionDetailsForPrinter(this.result.getFatalException(), "Beim Wiederherstellen bzw. Zur\u00fccksetzen des privaten Keystores ist ein Fehler aufgetreten. Er wurde deaktiviert. Fehler:"));
        }
        if (InitResult.PREF_ERROR.equals((Object)this.result.getResult())) {
            this.printer.accept("Da der Wurzelknoten der gespeicherten Einstellungen nicht wiederhergestellt werden konnte, konnte auch der private Keystore nicht wiederhergestellt werden. Er wird deaktiviert.");
        }
    }
}

