/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.exception;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.iqtig.packer.gui.GPackerRtWrapper;
import org.iqtig.packer.gui.exception.AbstractGPackerExceptionProcessor;
import org.iqtig.packer.shared.error.ValidationErrorException;
import org.iqtig.packer.shared.error.crypto.CryptoError;
import org.iqtig.packer.shared.error.crypto.CryptoException;
import org.xml.sax.SAXParseException;

public class GPackerExceptionProcessor
extends AbstractGPackerExceptionProcessor {
    ExecutionException exception;
    Consumer<String> printer;

    public GPackerExceptionProcessor(ExecutionException exception, Consumer<String> printer) {
        this.exception = exception;
        this.printer = printer;
    }

    @Override
    public void process() {
        Throwable cause = this.getCause();
        if (cause instanceof FileNotFoundException) {
            this.printer.accept(this.exception.getMessage());
        } else if (cause instanceof OutOfMemoryError) {
            this.printer.accept("Es ist nicht gen\u00fcgend Speicher vorhanden, um einer Datei dieser Gr\u00f6\u00dfe zu verarbeiten. Starten sie bspw. die Anwendung mittels \"java -jar GPacker-X.X.X-SNAPSHOT-jar-with-dependencies.jar -Xms256m -Xmx2g\", um die Speichergr\u00f6\u00dfe entsprechend zu erh\u00f6hen.");
        } else if (cause instanceof ValidationErrorException) {
            ValidationErrorException castedCause = (ValidationErrorException)cause;
            this.printer.accept(castedCause.getId() + ": " + castedCause.getErrorMessage());
        } else if (cause instanceof Base64DecodingException) {
            this.printer.accept("Die Schl\u00fcsseldatei konnte nicht verarbeitet werden!");
        } else if (cause instanceof SAXParseException) {
            this.printer.accept("Die zu verarbeitende XML-Datei konnte nicht eingelesen werden. M\u00f6gliche Ursachen z.B.: Die Datei ist keine XML-Datei, enth\u00e4lt einen formalen Fehler oder die Zeichenkodierung (Soll:UTF-8) stimmt nicht. " + cause.getClass().getSimpleName() + " - " + cause.getMessage());
        } else if (cause instanceof RuntimeException) {
            this.diffRuntimeException();
        } else {
            this.printer.accept("Es ist ein nicht ausdifferenzierter Fehler aufgetreten: " + cause.getClass().getSimpleName() + " - " + cause.getMessage());
        }
    }

    private Throwable getCause() {
        Throwable cause = this.exception.getCause();
        if (cause instanceof GPackerRtWrapper) {
            cause = cause.getCause();
        }
        return cause;
    }

    private void diffRuntimeException() {
        CryptoException cryptoException = this.extractCryptoException();
        if (cryptoException != null) {
            List<CryptoError> errors = cryptoException.getErrors();
            errors.stream().forEach(error -> this.processCryptoError((CryptoError)error));
        } else {
            Throwable cause = this.getCause();
            this.printer.accept("Ein technischer Fehler ist aufgetreten. Bitte wenden Sie mit folgenden Informationen an den IQTIG-Verfahrenssupport: " + cause.getClass().getSimpleName() + " - " + cause.getMessage() + "\n" + this.getStackTracesAsString(cause));
        }
    }

    private void processCryptoError(CryptoError error) {
        this.printer.accept("Es trat folgender Crypto-Fehler auf: " + error.getErrorId().getText());
    }

    private CryptoException extractCryptoException() {
        Throwable cause;
        ArrayList<Throwable> listOfCauses = new ArrayList<Throwable>();
        for (cause = this.exception.getCause(); cause != null && !(cause instanceof CryptoException) && !listOfCauses.contains(cause); cause = cause.getCause()) {
            listOfCauses.add(cause);
        }
        return (CryptoException)cause;
    }
}

