/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui.constants;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.iqtig.packer.gui.constants.Action;
import org.iqtig.packer.gui.constants.Labeled;
import org.iqtig.packer.gui.constants.Tag;

public enum Profile implements Labeled
{
    P1A(EnumSet.of(Action.ENCRYPT), "LE - Leistungserbringer (Datenlieferung mit Transplantationen)", Arrays.asList(Tag.PATIENT, Tag.QS_DATA, Tag.PATIENT_TX), true),
    P1B(EnumSet.of(Action.ENCRYPT), "LE - Leistungserbringer (Datenlieferung ohne Transplantationen)", Arrays.asList(Tag.PATIENT, Tag.QS_DATA), true),
    P2(EnumSet.of(Action.ENCRYPT), "DAS - Datenannahmestelle f\u00fcr Krankenhaus bzw. kollektivvertragl. \u00c4rzte", Arrays.asList(Tag.CARE_PROVIDER, Tag.QS_DATA), true),
    P3(EnumSet.of(Action.ENCRYPT), "DAS - Datenannahmestelle f\u00fcr selektivvertragl. \u00c4rzte bzw. Programmbeurteilung", Arrays.asList(Tag.CARE_PROVIDER), true),
    P4(EnumSet.of(Action.DECRYPT), "DAS - Datenannahmestelle f\u00fcr Krankenhaus bzw. kollektivvertragl. \u00c4rzte", Arrays.asList(Tag.QS_DATA), true),
    P5(EnumSet.of(Action.DECRYPT), "VST - Vertrauensstelle", Arrays.asList(Tag.PATIENT), true),
    P6(EnumSet.of(Action.DECRYPT), "BAS - Bundesauswertungsstelle", Arrays.asList(Tag.CARE_PROVIDER, Tag.QS_DATA), true),
    P_KREBSREGISTER(EnumSet.of(Action.ENCRYPT), "Klinisches Krebsregister", Arrays.asList(Tag.QS_DATA), true),
    P_INDIVIDUELL(EnumSet.of(Action.DECRYPT, Action.ENCRYPT), "Individuell", Arrays.asList(Tag.values()), false),
    P_ZERTIFIKATSTAUSCH(EnumSet.of(Action.DECRYPT, Action.ENCRYPT), "Zertifikatstausch PSP", Arrays.asList(new Tag[0]), true),
    P_DATENFLUSSPROTOKOLL_STRUKTURABFRAGEN(EnumSet.of(Action.DECRYPT, Action.ENCRYPT), "Datenflussprotokoll Strukturabfragen", Arrays.asList(new Tag[0]), true);

    private final Set<Action> actions;
    private final String label;
    private final List<Tag> tags;
    private final boolean fixedImmutableProfile;

    private Profile(Set<Action> actions, String label, List<Tag> tags, boolean isFixedImmutableProfile) {
        this.actions = actions;
        this.label = label;
        this.tags = tags;
        this.fixedImmutableProfile = isFixedImmutableProfile;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public static List<Profile> valuesByAction(Action action) {
        if (action == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(Profile.values()).filter(i -> i.actions.contains(action)).collect(Collectors.toList());
    }

    public static Profile getProfileWithLongestLabel() {
        Profile result = null;
        for (Profile value : Profile.values()) {
            if (result != null && value.getLabel().length() <= result.getLabel().length()) continue;
            result = value;
        }
        return result;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public boolean isFixedImmutableProfile() {
        return this.fixedImmutableProfile;
    }
}

