/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultCaret;
import org.apache.commons.lang3.StringUtils;
import org.iqtig.packer.gui.FileChooserFilters;
import org.iqtig.packer.gui.GPackerConsolePrinter;
import org.iqtig.packer.gui.GPackerModel;
import org.iqtig.packer.gui.GPackerViewCallback;
import org.iqtig.packer.gui.comp.MessageMode;
import org.iqtig.packer.gui.comp.ModelReferences;
import org.iqtig.packer.gui.comp.ProgressIndicationFeedback;
import org.iqtig.packer.gui.comp.View;
import org.iqtig.packer.gui.constants.Action;
import org.iqtig.packer.gui.constants.GPackerConstants;
import org.iqtig.packer.gui.constants.InputFiletype;
import org.iqtig.packer.gui.constants.KeyfileType;
import org.iqtig.packer.gui.constants.KeymanagementStatusState;
import org.iqtig.packer.gui.constants.KeystoreState;
import org.iqtig.packer.gui.constants.Keytype;
import org.iqtig.packer.gui.constants.KeyviewState;
import org.iqtig.packer.gui.constants.Labeled;
import org.iqtig.packer.gui.constants.ProcessingMode;
import org.iqtig.packer.gui.constants.Profile;
import org.iqtig.packer.gui.constants.Tag;
import org.iqtig.packer.gui.exception.AbstractGPackerExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreDiscardPrivateKeysExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreLoadKeysExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreLockExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreResetExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreResetPasswordExceptionProcessor;
import org.iqtig.packer.gui.exception.GPackerPrivKeystoreUnlockExceptionProcessor;
import org.iqtig.packer.gui.keymanagement.KeyAddResult;
import org.iqtig.packer.gui.keymanagement.KeyBoxEntry;
import org.iqtig.packer.gui.keymanagement.KeyContainer;
import org.iqtig.packer.gui.keymanagement.KeyList;
import org.iqtig.packer.gui.keymanagement.keystore.PrivateKeystore;
import org.iqtig.packer.gui.keymanagement.keystore.output.DefaultResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeylistOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeylistResult;
import org.iqtig.packer.gui.keymanagement.keystore.output.KeystoreOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.UnlockOutput;
import org.iqtig.packer.gui.keymanagement.keystore.output.UnlockResult;
import org.iqtig.packer.gui.swing.BiDirectionalCheckBoxBinder;
import org.iqtig.packer.gui.swing.BiDirectionalEnumComboboxBinder;
import org.iqtig.packer.gui.swing.BiDirectionalRadiobuttonBinder;
import org.iqtig.packer.gui.swing.BiDirectionalTextBinder;
import org.iqtig.packer.gui.swing.DefaultButtonListener;
import org.iqtig.packer.gui.swing.DefaultDisplayValueRetrieverFunction;
import org.iqtig.packer.gui.swing.DefaultFlexibleListCellRenderer;
import org.iqtig.packer.gui.swing.EnablementSwitcher;
import org.iqtig.packer.gui.swing.NeutralDisplayValueRetrieverFunction;
import org.iqtig.packer.gui.swing.customized.ImageFontIconCustom;
import org.iqtig.packer.gui.utils.FileUtils;
import org.iqtig.packer.gui.utils.KeyManagementStatusProducer;
import org.iqtig.packer.gui.utils.TypeConverter;

public class GPackerView
implements View<GPackerView, GPackerViewCallback, GPackerModel> {
    public static final String HEADING_TAG_AND_KEY_FILE_SELECTION_UNSPECIFIC = "Elemente und Schl\u00fcssel";
    public static final String HEADING_TAG_AND_KEY_FILE_SELECTION_DECRYPT = "Elemente und private Schl\u00fcssel";
    public static final String HEADING_TAG_AND_KEY_FILE_SELECTION_ENCRYPT = "Elemente und \u00f6ffentliche Schl\u00fcssel";
    public static final Color COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GREEN = new Color(0, 173, 2);
    public static final Color COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_RED = new Color(232, 0, 0);
    public static final Color COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GRAY = new Color(180, 180, 180);
    public static final int SIZE_LOCK = 30;
    private final JFileChooser fileChooserInputFilePMode = new JFileChooser();
    private final JFileChooser fileChooserOutputFolderPMode = new JFileChooser();
    private final JFileChooser fileChooserInputFileKMode = new JFileChooser();
    private final JFileChooser fileChooserOutputFolderKMode = new JFileChooser();
    private final JFileChooser fileChooserActualKeyfile = new JFileChooser();
    private JPanel contentPaine;
    private JTabbedPane tabbedPaneMode;
    private JComboBox<Action> comboBoxSelectAction;
    private JComboBox<Profile> comboBoxSelectProfile;
    private JComboBox comboBoxSelectKeyForQsData;
    private JComboBox comboBoxSelectKeyForCarePrv;
    private JComboBox comboBoxSelectKeyForPatient;
    private JComboBox comboBoxSelectKeyForPatientTx;
    private JButton btnSelectInput;
    private JButton btnOpenFolderInput;
    private JButton btnSelectOutput;
    private JButton btnOpenFolderOutput;
    private JCheckBox checkBoxSelectOptionTxEncryption;
    private JCheckBox checkBoxSelectTagQsData;
    private JCheckBox checkBoxSelectTagCareProvider;
    private JCheckBox checkBoxSelectTagPatient;
    private JCheckBox checkBoxSelectTagPatientTx;
    private JTextField inputTextRegistrationNumberPMode;
    private JTextField inputTextTxEncryptionPassword;
    private JLabel outputTextSelectedFileSelectionInput;
    private JLabel outputTextSelectedFileSelectionOutput;
    private JLabel labelInputFile;
    private JLabel labelAction;
    private JLabel labelProfile;
    private JLabel labelRegNo;
    private JLabel labelPassword;
    private JLabel labelFileNameToBeTxEncryptionPMode;
    private JLabel labelHeadingTagsAndKeyFiles;
    private JLabel labelOutputFolder;
    private ImageFontIconCustom imageIconCustomLock;
    private JButton btnLockUnlockPrivateKeys;
    private JButton btnResetPassword;
    private JButton btnDiscardKeys;
    private JPasswordField passwordFieldLockKeyStore;
    private JPasswordField passwordFieldLockKeystoreRepeat;
    private JButton btnExecute;
    private JButton btnExit;
    private JButton btnClearPreferences;
    private JButton btnClearConsole;
    private JTextArea textAreaOutputConsole;
    private JProgressBar progressBarExecutionProgress;
    private JComboBox<Action> comboBoxSelectActionKMode;
    private JComboBox comboBoxSelectKeyKMode;
    private JButton btnSelectInputKMode;
    private JButton btnOpenFolderInputKMode;
    private JButton btnSelectOutputKMode;
    private JButton btnOpenFolderOutputKMode;
    private JLabel labelFileNameLabelLabelKMode;
    private JLabel labelFileNameToBeTxEncryptionKMode;
    private JLabel outputTextSelectedFileSelectionInputKMode;
    private JLabel outputTextSelectedFileSelectionOutputKMode;
    private JComboBox<KeyBoxEntry> comboBoxSelectAddedKeys;
    private JComboBox comboBoxSelectKeyfileType;
    private JButton btnDeleteKeyFromList;
    private JButton btnNewKey;
    private JButton btnSelectActualKeyfile;
    private JButton btnOpenFolderActualKeyfile;
    private JButton btnAddKey;
    private ButtonGroup privateOrPublicSelectionGroup;
    private JRadioButton radioBtnPublic;
    private JRadioButton radioBtnPrivate;
    private JPasswordField passwordFieldKeystore;
    private JTextField inputTextAlias;
    private JPasswordField passwordFieldKeyentry;
    private JTextField inputTextKeyName;
    private JLabel labelKeymanagementStatus;
    private JLabel labelKeyfile;
    private JLabel outputTextSelectedFileActualKeyfile;
    private Map<Tag, JComboBox> comboBoxMapSelectKeyTag;
    private final Map<Tag, ModelReferences<Boolean>> selectionModelReferencesByTag = new EnumMap<Tag, ModelReferences<Boolean>>(Tag.class);
    private final Map<Tag, JCheckBox> widgetsByTagSelectionCheckboxes = new EnumMap<Tag, JCheckBox>(Tag.class);
    PrivateKeystore privateKeystore;
    GPackerConsolePrinter consolePrinter;
    PrivateKeystoreComponents privateKeystoreComponents = new PrivateKeystoreComponents();

    public GPackerView() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getPane() {
        return this.contentPaine;
    }

    public GPackerView setPrivateKeystore(PrivateKeystore privateKeystore) {
        this.privateKeystore = privateKeystore;
        return this;
    }

    public GPackerView setConsolePrinter(GPackerConsolePrinter consolePrinter) {
        this.consolePrinter = consolePrinter;
        return this;
    }

    @Override
    public GPackerView init() {
        this.$$$setupUI$$$();
        this.labelHeadingTagsAndKeyFiles.setText(HEADING_TAG_AND_KEY_FILE_SELECTION_UNSPECIFIC);
        this.initRadioButtons();
        this.initComboBoxes();
        this.initFileChoosers();
        this.initProgressBar();
        this.setLabelsToMatchValidationMessagesOrBeingFrequent();
        this.nameWidgetsForClickRoboter();
        return this;
    }

    @Override
    public GPackerView bindStateAndData(GPackerModel model) {
        this.declareTagReferences(model);
        this.setProcessingMode(model);
        this.setKeyTypeSelected(model);
        this.bindStateChangeProcessingMode(model);
        this.bindBasicStateFileSelection(model, "inputFile", this.outputTextSelectedFileSelectionInput, this.btnOpenFolderInput);
        this.bindBasicStateFileSelection(model, "outputFolder", this.outputTextSelectedFileSelectionOutput, this.btnOpenFolderOutput);
        this.bindSpecificStateChangeInputFileSelection(model);
        this.bindStateChangeActionSelection(model);
        this.bindBasicStateFileSelection(model, "inputFileKMode", this.outputTextSelectedFileSelectionInputKMode, this.btnOpenFolderInputKMode);
        this.bindBasicStateFileSelection(model, "outputFolderKMode", this.outputTextSelectedFileSelectionOutputKMode, this.btnOpenFolderOutputKMode);
        this.bindSpecificStateChangeInputFileSelectionKMode(model);
        this.bindStateChangeActionSelectionKMode(model);
        this.bindBasicStateFileSelection(model, "actualSelectedKeyfile", this.outputTextSelectedFileActualKeyfile, this.btnOpenFolderActualKeyfile);
        this.bindStateChangeKeyList(model);
        this.bindStateChangeKeynameSelection(model);
        this.bindStateChangeKeyfileTypeSelection(model);
        this.bindStateChangeAddedKeylist(model);
        this.bindStateChangeKeyviewState(model);
        this.bindStateChangePrivateKeystoreState(model);
        if (!this.privateKeystore.isActive()) {
            model.setPrivateKeystoreState(KeystoreState.INACTIVE);
        }
        this.setPrivateKeystoreState(model);
        this.resetKeyManagementStatusLabel(model, Keytype.PRIVATE);
        this.tabbedPaneMode.addChangeListener(e -> this.setProcessingMode(model));
        model.addPropertyChangeListener(e -> {
            if ("selectedOptionTxEncryption".equals(e.getPropertyName()) || "action".equals(e.getPropertyName())) {
                File inputFile = model.getInputFilePMode();
                Profile profile = model.getProfile();
                boolean isDatenflussStrukturabfrage = profile != null && Profile.P_DATENFLUSSPROTOKOLL_STRUKTURABFRAGEN.equals(profile);
                boolean isCertFile = GPackerConstants.P_IS_CER.test(inputFile);
                boolean isCertEncedFile = GPackerConstants.P_IS_CER_ZIP_AES.test(inputFile);
                boolean isTxEncryptionSelected = model.isSelectedOptionTxEncryption();
                boolean requiresRegNoInput = isTxEncryptionSelected && model.getAction() == Action.ENCRYPT && !isCertFile && !isCertEncedFile && !isDatenflussStrukturabfrage;
                boolean showFileLabel = model.getAction() == Action.ENCRYPT && isTxEncryptionSelected;
                this.inputTextTxEncryptionPassword.setEnabled(isTxEncryptionSelected);
                this.inputTextRegistrationNumberPMode.setEnabled(requiresRegNoInput);
                this.labelFileNameToBeTxEncryptionPMode.setVisible(showFileLabel);
            }
        });
        model.addPropertyChangeListener(e -> {
            if ("profile".equals(e.getPropertyName())) {
                Profile profile = (Profile)e.getNewValue();
                this.enableDisableWidgetsByProfile(profile);
                boolean profileIsKrebsregister = Profile.P_KREBSREGISTER.equals(profile);
                boolean profileIsDatenflussprotokollStrukturabfrage = Profile.P_DATENFLUSSPROTOKOLL_STRUKTURABFRAGEN.equals(profile);
                boolean isZipAesFile = GPackerConstants.P_IS_ZIP_AES.test(model.getInputFilePMode());
                boolean txCheckboxShouldBeEnabled = !profileIsKrebsregister && !Profile.P_ZERTIFIKATSTAUSCH.equals(profile) && !profileIsDatenflussprotokollStrukturabfrage && model.getAction() != Action.DECRYPT;
                this.checkBoxSelectOptionTxEncryption.setEnabled(txCheckboxShouldBeEnabled);
                if (profileIsKrebsregister) {
                    model.setSelectedOptionTxEncryption(false);
                    model.setRegistrationNumberPMode(null);
                    model.setTxEncryptionPassword(null);
                } else if (profileIsDatenflussprotokollStrukturabfrage) {
                    model.setSelectedOptionTxEncryption(false);
                    model.setSelectedOptionTxEncryption(true);
                    model.setRegistrationNumberPMode(null);
                    this.inputTextRegistrationNumberPMode.setEnabled(false);
                    this.inputTextTxEncryptionPassword.setEnabled(true);
                }
            }
        });
        for (Map.Entry<Tag, ModelReferences<Boolean>> tagSelectionRefs : this.selectionModelReferencesByTag.entrySet()) {
            String selectionPropertyName = tagSelectionRefs.getValue().modelProperty;
            Tag tag = tagSelectionRefs.getKey();
            model.addPropertyChangeListener(e -> {
                if (selectionPropertyName.equals(e.getPropertyName())) {
                    Boolean isSelected = (Boolean)e.getNewValue();
                    this.comboBoxMapSelectKeyTag.get((Object)tag).setEnabled(isSelected);
                }
            });
        }
        model.addPropertyChangeListener(e -> {
            if ("registrationNumberPMode".equals(e.getPropertyName())) {
                this.labelFileNameToBeTxEncryptionPMode.setText("Dateiname: " + this.produceFilenamePMode(model));
            }
        });
        new BiDirectionalEnumComboboxBinder<Action>("action", model::setAction, model, this.comboBoxSelectAction);
        new BiDirectionalEnumComboboxBinder<Profile>("profile", model::setProfile, model, this.comboBoxSelectProfile);
        new BiDirectionalTextBinder("registrationNumberPMode", model::setRegistrationNumberPMode, model, this.inputTextRegistrationNumberPMode);
        new BiDirectionalTextBinder("txEncryptionPassword", model::setTxEncryptionPassword, model, this.inputTextTxEncryptionPassword);
        new BiDirectionalCheckBoxBinder("selectedOptionTxEncryption", model::setSelectedOptionTxEncryption, model, this.checkBoxSelectOptionTxEncryption);
        new BiDirectionalCheckBoxBinder("selectedTagCareProvider", model::setSelectedTagCareProvider, model, this.checkBoxSelectTagCareProvider);
        new BiDirectionalCheckBoxBinder("selectedTagQsData", model::setSelectedTagQsData, model, this.checkBoxSelectTagQsData);
        new BiDirectionalCheckBoxBinder("selectedTagPatient", model::setSelectedTagPatient, model, this.checkBoxSelectTagPatient);
        new BiDirectionalCheckBoxBinder("selectedTagPatientTx", model::setSelectedTagPatientTx, model, this.checkBoxSelectTagPatientTx);
        new BiDirectionalEnumComboboxBinder<KeyBoxEntry>("keyTagCareProvider", model::setKeyTagCareProvider, model, this.comboBoxSelectKeyForCarePrv);
        new BiDirectionalEnumComboboxBinder<KeyBoxEntry>("keyTagQsData", model::setKeyTagQsData, model, this.comboBoxSelectKeyForQsData);
        new BiDirectionalEnumComboboxBinder<KeyBoxEntry>("keyTagPatient", model::setKeyTagPatient, model, this.comboBoxSelectKeyForPatient);
        new BiDirectionalEnumComboboxBinder<KeyBoxEntry>("keyTagPatientTx", model::setKeyTagPatientTx, model, this.comboBoxSelectKeyForPatientTx);
        new BiDirectionalEnumComboboxBinder<Action>("actionKMode", model::setActionKMode, model, this.comboBoxSelectActionKMode);
        new BiDirectionalEnumComboboxBinder<KeyBoxEntry>("selectedKeynameKMode", model::setSelectedKeynameKMode, model, this.comboBoxSelectKeyKMode);
        new BiDirectionalRadiobuttonBinder("privateKeysSelected", model::setPrivateKeysSelected, model, this.radioBtnPrivate);
        new BiDirectionalRadiobuttonBinder("publicKeysSelected", model::setPublicKeysSelected, model, this.radioBtnPublic);
        new BiDirectionalEnumComboboxBinder<KeyBoxEntry>("selectedKeyname", model::setSelectedKeyname, model, this.comboBoxSelectAddedKeys);
        new BiDirectionalEnumComboboxBinder<KeyfileType>("keyfileType", model::setKeyfileType, model, this.comboBoxSelectKeyfileType);
        new BiDirectionalTextBinder("keyName", model::setKeyName, model, this.inputTextKeyName);
        new BiDirectionalTextBinder("keystorePassword", model::setPasswordKeystore, model, this.passwordFieldKeystore);
        new BiDirectionalTextBinder("aliasKeyentry", model::setAliasKeyentry, model, this.inputTextAlias);
        new BiDirectionalTextBinder("passwordKeyentry", model::setPasswordKeyentry, model, this.passwordFieldKeyentry);
        new BiDirectionalTextBinder("passwordLockKeystore", model::setPasswordLockKeystore, model, this.passwordFieldLockKeyStore);
        new BiDirectionalTextBinder("passwordLockKeystoreRepeat", model::setPasswordLockKeystoreRepeat, model, this.passwordFieldLockKeystoreRepeat);
        new BiDirectionalTextBinder("consoleText", model::setConsoleText, model, this.textAreaOutputConsole);
        this.setBackgroundToIndicateChoosability(false, this.outputTextSelectedFileActualKeyfile);
        return this;
    }

    @Override
    public GPackerView bindActions(GPackerViewCallback viewCallBack, GPackerModel model) {
        DefaultButtonListener listener = new DefaultButtonListener(i -> {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = model::getInputFileSelectedLastGlobal;
            supplierArray[1] = model::getInputFilePMode;
            supplierArray[2] = model::getInputFileSelectedLastPMode;
            this.showFileChooser(this.fileChooserInputFilePMode, model::setInputFilePMode, supplierArray);
        });
        this.btnSelectInput.addActionListener(listener);
        listener = new DefaultButtonListener(i -> {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = model::getOutputFolderSelectedLastGlobal;
            supplierArray[1] = model::getOutputFolderPMode;
            this.showFileChooser(this.fileChooserOutputFolderPMode, model::setOutputFolderPMode, supplierArray);
        });
        this.btnSelectOutput.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.openReferringDirectory(model.getInputFilePMode()));
        this.btnOpenFolderInput.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.openReferringDirectory(model.getOutputFolderPMode()));
        this.btnOpenFolderOutput.addActionListener(listener);
        listener = new DefaultButtonListener(i -> {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = model::getInputFileSelectedLastGlobal;
            supplierArray[1] = model::getInputFileKMode;
            supplierArray[2] = model::getInputFileSelectedLastKMode;
            this.showFileChooser(this.fileChooserInputFileKMode, model::setInputFileKMode, supplierArray);
        });
        this.btnSelectInputKMode.addActionListener(listener);
        listener = new DefaultButtonListener(i -> {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = model::getOutputFolderSelectedLastGlobal;
            supplierArray[1] = model::getOutputFolderKMode;
            this.showFileChooser(this.fileChooserOutputFolderKMode, model::setOutputFolderKMode, supplierArray);
        });
        this.btnSelectOutputKMode.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.openReferringDirectory(model.getInputFileKMode()));
        this.btnOpenFolderInputKMode.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.openReferringDirectory(model.getOutputFolderKMode()));
        this.btnOpenFolderOutputKMode.addActionListener(listener);
        listener = new DefaultButtonListener(i -> {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = model::getActualSelectedKeyfile;
            supplierArray[1] = model::getActualSelectedKeyfileLast;
            this.showFileChooser(this.fileChooserActualKeyfile, model::setActualSelectedKeyfile, supplierArray);
        });
        this.btnSelectActualKeyfile.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.openReferringDirectory(model.getActualSelectedKeyfile()));
        this.btnOpenFolderActualKeyfile.addActionListener(listener);
        listener = new DefaultButtonListener(i -> this.switchToPrivateKeys(model));
        this.radioBtnPrivate.addActionListener(listener);
        listener = new DefaultButtonListener(i -> this.switchToPublicKeys(model));
        this.radioBtnPublic.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.addKey(new AddKeyViewProcessor()));
        this.btnAddKey.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.deleteKey(new DeleteKeyViewProcessor()));
        this.btnDeleteKeyFromList.addActionListener(listener);
        listener = new DefaultButtonListener(i -> this.newKey(model));
        this.btnNewKey.addActionListener(listener);
        listener = new DefaultButtonListener(i -> this.privateKeystoreComponents.lockUnlockPrivateKeystoreSafe(model));
        this.btnLockUnlockPrivateKeys.addActionListener(listener);
        listener = new DefaultButtonListener(i -> this.discardPrivateKeys(model));
        this.btnDiscardKeys.addActionListener(listener);
        listener = new DefaultButtonListener(i -> this.resetPassword(model));
        this.btnResetPassword.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.doShutDown());
        this.btnExit.addActionListener(listener);
        listener = new DefaultButtonListener(i -> this.textAreaOutputConsole.setText(null));
        this.btnClearConsole.addActionListener(listener);
        listener = new DefaultButtonListener(i -> viewCallBack.clearPreferences());
        this.btnClearPreferences.addActionListener(listener);
        listener = new DefaultButtonListener(i -> {
            EnablementSwitcher enablementSwitcher = new EnablementSwitcher(this.comboBoxSelectAction, this.comboBoxSelectProfile, this.btnSelectInput, this.btnSelectOutput, this.btnExecute, this.btnExit, this.btnClearPreferences, this.checkBoxSelectOptionTxEncryption, this.checkBoxSelectTagCareProvider, this.checkBoxSelectTagQsData, this.checkBoxSelectTagPatient, this.checkBoxSelectTagPatientTx, this.inputTextRegistrationNumberPMode, this.inputTextTxEncryptionPassword, this.btnClearConsole, this.btnOpenFolderInput, this.btnOpenFolderOutput);
            enablementSwitcher.setDisabled();
            viewCallBack.doExecute(new ProgressIndicationFeedback(){

                @Override
                public void defineInitialProgressMax(int maximum) {
                    SwingUtilities.invokeLater(() -> {
                        GPackerView.this.progressBarExecutionProgress.setMinimum(0);
                        GPackerView.this.progressBarExecutionProgress.setMaximum(maximum);
                        GPackerView.this.progressBarExecutionProgress.setValue(0);
                    });
                }

                @Override
                public void burnDownProgress(int latestProgress) {
                    SwingUtilities.invokeLater(() -> {
                        int newTotalProgress = GPackerView.this.progressBarExecutionProgress.getValue() + latestProgress;
                        GPackerView.this.progressBarExecutionProgress.setValue(newTotalProgress);
                    });
                }

                @Override
                public void increaseMax(int amountToIncrease) {
                    SwingUtilities.invokeLater(() -> GPackerView.this.progressBarExecutionProgress.setMaximum(GPackerView.this.progressBarExecutionProgress.getMaximum() + amountToIncrease));
                }
            }, j -> enablementSwitcher.returnToPreviousState());
        });
        this.btnExecute.addActionListener(listener);
        return this;
    }

    void setProcessingMode(GPackerModel model) {
        if (0 == this.tabbedPaneMode.getSelectedIndex()) {
            model.setProcessingMode(ProcessingMode.PMODE);
        } else if (1 == this.tabbedPaneMode.getSelectedIndex()) {
            model.setProcessingMode(ProcessingMode.KMODE);
        } else if (2 == this.tabbedPaneMode.getSelectedIndex()) {
            model.setProcessingMode(ProcessingMode.KEYMANAGEMENT);
        }
    }

    void setPrivateKeystoreState(GPackerModel model) {
        model.setPrivateKeystoreState(this.privateKeystore.getState());
    }

    void setKeyTypeSelected(GPackerModel model) {
        model.setPrivateKeysSelected(true);
        model.setPublicKeysSelected(false);
    }

    private void enableDisableWidgetsByProfile(Profile profile) {
        for (Tag tag : Tag.values()) {
            boolean enableSelection;
            boolean setSelected;
            if (profile == null) {
                setSelected = false;
                enableSelection = false;
            } else if (profile.isFixedImmutableProfile()) {
                if (profile.getTags().contains((Object)tag)) {
                    setSelected = true;
                    enableSelection = false;
                } else {
                    setSelected = false;
                    enableSelection = false;
                }
            } else if (profile.getTags().contains((Object)tag)) {
                setSelected = false;
                enableSelection = true;
            } else {
                setSelected = false;
                enableSelection = false;
            }
            this.propagateTagSelection(tag, setSelected, enableSelection, this.widgetsByTagSelectionCheckboxes, this.selectionModelReferencesByTag);
        }
    }

    private void propagateTagSelection(Tag tag, boolean setSelected, boolean enableSelection, Map<Tag, JCheckBox> tagCheckBoxesByTag, Map<Tag, ModelReferences<Boolean>> tagSelectionModelByTag) {
        Consumer<Boolean> modelSetter = tagSelectionModelByTag.get((Object)((Object)tag)).setter;
        JCheckBox jCheckBox = tagCheckBoxesByTag.get((Object)tag);
        modelSetter.accept(setSelected);
        jCheckBox.setEnabled(enableSelection);
    }

    private void deriveAndSetTxChoosabiltiyFromModel(GPackerModel model, Action selectedAction) {
        File selectedInputFile = model.getInputFilePMode();
        Profile profile = model.getProfile();
        boolean isProfileDatenflussProtokoll = Profile.P_DATENFLUSSPROTOKOLL_STRUKTURABFRAGEN.equals(profile);
        boolean selectedFileNotNull = selectedInputFile != null;
        boolean isZipAesTransportFileAsInputSelected = selectedFileNotNull && GPackerConstants.P_IS_ZIP_AES.test(selectedInputFile);
        boolean isXmlFileAsInputSelected = selectedFileNotNull && GPackerConstants.P_IS_XML_FILE.test(selectedInputFile);
        boolean isCertFileAsInputSelected = selectedFileNotNull && GPackerConstants.P_IS_CER.test(selectedInputFile);
        boolean isCertFileEncedAsInputSelected = selectedFileNotNull && GPackerConstants.P_IS_CER_ZIP_AES.test(selectedInputFile);
        boolean isEncryption = Action.ENCRYPT == selectedAction;
        boolean isDecryption = Action.DECRYPT == selectedAction;
        this.checkBoxSelectOptionTxEncryption.setEnabled(isEncryption && isXmlFileAsInputSelected);
        if (isDecryption && isZipAesTransportFileAsInputSelected || isCertFileAsInputSelected || isCertFileEncedAsInputSelected || isProfileDatenflussProtokoll) {
            SwingUtilities.invokeLater(() -> model.setSelectedOptionTxEncryption(true));
        } else {
            SwingUtilities.invokeLater(() -> model.setSelectedOptionTxEncryption(false));
        }
    }

    void resetKeyManagementStatusLabel(GPackerModel model, Keytype type) {
        if (Keytype.PUBLIC.equals((Object)type)) {
            this.processKeyManagementStatus(model, KeymanagementStatusState.PUBLIC_DEFAULT);
        } else if (Keytype.PRIVATE.equals((Object)type)) {
            if (KeystoreState.LOCKED.equals((Object)model.getPrivateKeystoreState())) {
                this.processKeyManagementStatus(model, KeymanagementStatusState.PRIVATE_TO_BE_UNLOCKED_OR_DISCARDED);
            } else {
                this.processKeyManagementStatus(model, KeymanagementStatusState.PRIVATE_DEFAULT);
            }
        }
    }

    void resetKeyManagementfields(GPackerModel model) {
        model.setSelectedKeyname(null);
        model.setActualSelectedKeyfile(null);
        model.setPasswordKeystore(null);
        model.setAliasKeyentry(null);
        model.setPasswordKeyentry(null);
    }

    private void enableKeystoreComponents(GPackerModel model, boolean enablingState) {
        this.passwordFieldKeystore.setEnabled(enablingState);
        this.inputTextAlias.setEnabled(enablingState);
    }

    void updateAddedKeyComboBox(GPackerModel model, String keyNameToBeSelected) {
        boolean actualKeylistSizeGreaterZero = model.getPrivateKeysSelected() && model.getPrivateKeylist().size() > 0 || model.getPublicKeysSelected() && model.getPublicKeylist().size() > 0;
        List<KeyBoxEntry> listKeyNames = model.getPrivateKeysSelected() ? TypeConverter.makeKeyBoxEntries(model.getPrivateKeylist().getNames()) : TypeConverter.makeKeyBoxEntries(model.getPublicKeylist().getNames());
        this.setUpComboBox(this.comboBoxSelectAddedKeys, listKeyNames);
        if (keyNameToBeSelected != null) {
            model.setSelectedKeyname(new KeyBoxEntry(keyNameToBeSelected));
        }
        this.comboBoxSelectAddedKeys.setEnabled(actualKeylistSizeGreaterZero);
    }

    void updateKeyComboBoxes(GPackerModel model) {
        this.fillKeyComboBox(this.comboBoxSelectKeyKMode, model.getActionKMode(), model);
        this.fillTagKeyComboBoxes(model);
    }

    private void fillTagKeyComboBoxes(GPackerModel model) {
        this.comboBoxMapSelectKeyTag.entrySet().stream().forEach(entry -> this.fillKeyComboBox((JComboBox)entry.getValue(), model.getAction(), model));
    }

    private void loadKeydetails(GPackerModel model) {
        KeyContainer keyContainer = model.getSelectedKey();
        if (keyContainer != null) {
            model.setKeyfileType(keyContainer.getKeyFileType());
            model.setActualSelectedKeyfile(keyContainer.getKeyfile());
            model.setPasswordKeystore(keyContainer.getKeystorePassword());
            model.setAliasKeyentry(keyContainer.getKeyentryAlias());
            model.setPasswordKeyentry(keyContainer.getKeyentryPassword());
        }
    }

    private void clearKeydetails(GPackerModel model) {
        model.setKeyfileType(null);
        model.setActualSelectedKeyfile(null);
        model.setPasswordKeystore(null);
        model.setAliasKeyentry(null);
        model.setPasswordKeyentry(null);
    }

    private void disableKeydetails() {
        this.comboBoxSelectKeyfileType.setEnabled(false);
        this.outputTextSelectedFileActualKeyfile.setEnabled(false);
        this.passwordFieldKeystore.setEnabled(false);
        this.inputTextAlias.setEnabled(false);
        this.passwordFieldKeyentry.setEnabled(false);
    }

    private void disableKeymanagementParts() {
        this.btnSelectActualKeyfile.setEnabled(false);
        this.btnOpenFolderActualKeyfile.setEnabled(false);
        this.btnAddKey.setEnabled(false);
        this.inputTextKeyName.setEnabled(false);
        this.setBackgroundToIndicateChoosability(false, this.outputTextSelectedFileActualKeyfile);
        this.disableKeydetails();
    }

    private void disableKeymanagementElementsWhenLocked() {
        this.btnNewKey.setEnabled(false);
        this.disableKeymanagementParts();
    }

    private void setEnablingStateOfKeymanagementElementsWhenKeySelected() {
        this.btnNewKey.setEnabled(true);
        this.disableKeymanagementParts();
        this.btnOpenFolderActualKeyfile.setEnabled(true);
    }

    private void enableKeymanagementElementsWhenUnocked() {
        this.btnNewKey.setEnabled(true);
        this.comboBoxSelectKeyfileType.setEnabled(true);
        this.btnAddKey.setEnabled(true);
    }

    private void fillKeyComboBox(JComboBox comboBox, Action action, GPackerModel model) {
        List<String> keyBoxItems = Action.DECRYPT.equals(action) ? model.getPrivateKeylist().getNames() : model.getPublicKeylist().getNames();
        List<KeyBoxEntry> keyBoxEntries = TypeConverter.makeKeyBoxEntries(keyBoxItems);
        this.setUpComboBox(comboBox, keyBoxEntries);
    }

    private boolean checkIfLockingPasswordIsCorrect(GPackerModel model) {
        if (model.getPasswordLockKeystore() == null || model.getPasswordLockKeystore().isBlank()) {
            this.showMsgPopup("Passwort zum sperren der privaten Schl\u00fcssel darf nicht leer sein.", MessageMode.ERROR);
            return false;
        }
        if (!model.getPasswordLockKeystore().equals(model.getPasswordLockKeystoreRepeat())) {
            this.showMsgPopup("Passwort und Passwortwiederholung stimmen nicht \u00fcberein.", MessageMode.ERROR);
            return false;
        }
        return true;
    }

    private void bindBasicStateFileSelection(GPackerModel model, String propFileSelection, JLabel pathDisplayField, JButton openFolderButton) {
        model.addPropertyChangeListener(e -> {
            if (propFileSelection.equals(e.getPropertyName())) {
                File newValue = (File)e.getNewValue();
                String stringToBeDisplayed = newValue != null ? newValue.getPath() : null;
                pathDisplayField.setText(stringToBeDisplayed);
                boolean isAValueSelected = newValue != null;
                openFolderButton.setEnabled(isAValueSelected);
            }
        });
    }

    private void bindStateChangeProcessingMode(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("processingMode".equals(e.getPropertyName())) {
                ProcessingMode processingMode = (ProcessingMode)((Object)((Object)e.getNewValue()));
                this.btnExecute.setEnabled(!ProcessingMode.KEYMANAGEMENT.equals((Object)processingMode));
            }
        });
    }

    private void bindSpecificStateChangeInputFileSelection(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("inputFile".equals(e.getPropertyName())) {
                Action actionToBeSet;
                boolean isActionSelectionToBeEnabled;
                File newValue = (File)e.getNewValue();
                boolean isAValueSelected = newValue != null;
                InputFiletype inputFileType = InputFiletype.determineFiletype(newValue.getName());
                model.setInputFileTypePMode(inputFileType);
                if (InputFiletype.ZIP_AES.equals((Object)inputFileType) || InputFiletype.CER_ZIP_AES.equals((Object)inputFileType)) {
                    isActionSelectionToBeEnabled = false;
                    actionToBeSet = Action.DECRYPT;
                } else if (InputFiletype.CERTIFICATE.equals((Object)inputFileType)) {
                    isActionSelectionToBeEnabled = false;
                    actionToBeSet = Action.ENCRYPT;
                } else {
                    isActionSelectionToBeEnabled = isAValueSelected;
                    actionToBeSet = null;
                }
                this.setProfileForCertificate(model, actionToBeSet);
                this.updateFileLabel(model);
                this.comboBoxSelectAction.setEnabled(isActionSelectionToBeEnabled);
                SwingUtilities.invokeLater(() -> model.setAction(actionToBeSet));
                this.setBackgroundToIndicateChoosability(isAValueSelected, this.outputTextSelectedFileSelectionOutput);
                this.btnSelectOutput.setEnabled(isAValueSelected);
            }
        });
    }

    private void bindStateChangeActionSelection(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("action".equals(e.getPropertyName())) {
                Action action = (Action)e.getNewValue();
                model.setProfile(null);
                this.comboBoxSelectProfile.setEnabled(action != null);
                this.comboBoxSelectProfile.removeAllItems();
                this.comboBoxSelectProfile.addItem(null);
                for (Profile profile : Profile.valuesByAction(action)) {
                    this.comboBoxSelectProfile.addItem(profile);
                }
                FileFilter fileFilter = null;
                String headingTagAndKeyFileSelection = HEADING_TAG_AND_KEY_FILE_SELECTION_UNSPECIFIC;
                if (Action.DECRYPT == action) {
                    headingTagAndKeyFileSelection = HEADING_TAG_AND_KEY_FILE_SELECTION_DECRYPT;
                    fileFilter = FileChooserFilters.KEY_FILE_PRIVATE;
                } else if (Action.ENCRYPT == action) {
                    headingTagAndKeyFileSelection = HEADING_TAG_AND_KEY_FILE_SELECTION_ENCRYPT;
                    fileFilter = FileChooserFilters.KEY_FILE_PUBLIC;
                    this.checkBoxSelectOptionTxEncryption.setEnabled(true);
                }
                this.labelHeadingTagsAndKeyFiles.setText(headingTagAndKeyFileSelection);
                this.deriveAndSetTxChoosabiltiyFromModel(model, action);
                this.setProfileForCertificate(model, action);
                this.fillTagKeyComboBoxes(model);
            }
        });
    }

    private void setProfileForCertificate(GPackerModel model, Action action) {
        InputFiletype fileType = model.getInputFileTypePMode();
        this.comboBoxSelectProfile.removeItem(Profile.P_ZERTIFIKATSTAUSCH);
        if (fileType != null && (InputFiletype.CERTIFICATE.equals((Object)fileType) || InputFiletype.CER_ZIP_AES.equals((Object)fileType))) {
            this.comboBoxSelectProfile.addItem(Profile.P_ZERTIFIKATSTAUSCH);
            model.setProfile(Profile.P_ZERTIFIKATSTAUSCH);
            this.comboBoxSelectProfile.setEnabled(false);
            model.setRegistrationNumberPMode(null);
            this.inputTextRegistrationNumberPMode.setEnabled(false);
        } else {
            this.comboBoxSelectProfile.setEnabled(model.getAction() != null);
            model.setProfile(null);
        }
        this.deriveAndSetTxChoosabiltiyFromModel(model, action);
    }

    private void updateFileLabel(GPackerModel model) {
        this.labelFileNameToBeTxEncryptionPMode.setText("Dateiname: " + this.produceFilenamePMode(model));
        InputFiletype fileType = model.getInputFileTypePMode();
        boolean showFileLabel = Action.ENCRYPT == model.getAction() && model.isSelectedOptionTxEncryption();
        this.labelFileNameToBeTxEncryptionPMode.setVisible(showFileLabel);
    }

    private void bindSpecificStateChangeInputFileSelectionKMode(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("inputFileKMode".equals(e.getPropertyName())) {
                Action actionToBeSet;
                boolean isActionSelectionToBeEnabled;
                boolean isACertFile;
                File newValue = (File)e.getNewValue();
                InputFiletype fileType = InputFiletype.determineFiletype(newValue != null ? newValue.getName() : null);
                model.setInputFileTypeKMode(fileType);
                this.labelFileNameToBeTxEncryptionKMode.setText(this.composeNameForEncryptedFile(model.getInputFileTypeKMode()));
                boolean isAValueSelected = newValue != null;
                boolean isAZipAesTransportFile = isAValueSelected && GPackerConstants.P_IS_ZIP_AES.test(newValue);
                boolean bl = isACertFile = isAValueSelected && GPackerConstants.P_IS_CER.test(newValue);
                if (isAZipAesTransportFile) {
                    isActionSelectionToBeEnabled = false;
                    actionToBeSet = Action.DECRYPT;
                } else if (isACertFile) {
                    isActionSelectionToBeEnabled = false;
                    actionToBeSet = Action.ENCRYPT;
                } else {
                    isActionSelectionToBeEnabled = isAValueSelected;
                    actionToBeSet = null;
                }
                this.comboBoxSelectActionKMode.setEnabled(isActionSelectionToBeEnabled);
                SwingUtilities.invokeLater(() -> model.setActionKMode(actionToBeSet));
                this.setBackgroundToIndicateChoosability(isAValueSelected, this.outputTextSelectedFileSelectionOutputKMode);
                this.btnSelectOutputKMode.setEnabled(isAValueSelected);
            }
        });
    }

    private void bindStateChangeActionSelectionKMode(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("actionKMode".equals(e.getPropertyName())) {
                Action action = (Action)e.getNewValue();
                this.fillKeyComboBox(this.comboBoxSelectKeyKMode, model.getActionKMode(), model);
                if (action == null) {
                    this.comboBoxSelectKeyKMode.setEnabled(false);
                    this.labelFileNameToBeTxEncryptionKMode.setVisible(false);
                    this.labelFileNameLabelLabelKMode.setVisible(false);
                } else if (action.equals(Action.DECRYPT)) {
                    this.comboBoxSelectKeyKMode.setEnabled(true);
                    this.labelFileNameToBeTxEncryptionKMode.setVisible(false);
                    this.labelFileNameLabelLabelKMode.setVisible(false);
                } else {
                    this.comboBoxSelectKeyKMode.setEnabled(true);
                    this.labelFileNameToBeTxEncryptionKMode.setVisible(true);
                    this.labelFileNameLabelLabelKMode.setVisible(true);
                    this.labelFileNameToBeTxEncryptionKMode.setText(this.composeNameForEncryptedFile(model.getInputFileTypeKMode()));
                }
            }
        });
    }

    private String composeNameForEncryptedFile(InputFiletype inputFileType) {
        if (inputFileType == null || inputFileType.equals((Object)InputFiletype.CERTIFICATE)) {
            return GPackerConstants.FILE_NAME_PATTERN_CERT_ZIP_AES;
        }
        return GPackerConstants.FILE_NAME_PATTERN_KMODE_ZIP_AES;
    }

    private void bindStateChangeKeyList(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            boolean actualKeylistSizeGreaterZero;
            boolean keysChanged = "privateKeyList".equals(e.getPropertyName()) || "publicKeyList".equals(e.getPropertyName());
            boolean bl = actualKeylistSizeGreaterZero = model.getPrivateKeysSelected() && model.getPrivateKeylist().size() > 0 || model.getPublicKeysSelected() && model.getPublicKeylist().size() > 0;
            if (keysChanged) {
                this.comboBoxSelectAddedKeys.setEnabled(actualKeylistSizeGreaterZero);
            }
        });
    }

    private void bindStateChangeKeynameSelection(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("selectedKeyname".equals(e.getPropertyName())) {
                KeyBoxEntry selectedKeyBoxEntry = (KeyBoxEntry)e.getNewValue();
                if (selectedKeyBoxEntry != null) {
                    this.btnDeleteKeyFromList.setEnabled(true);
                    this.loadKeydetails(model);
                    model.setKeyviewState(KeyviewState.KEY_SELECTED);
                } else {
                    this.btnDeleteKeyFromList.setEnabled(false);
                    this.clearKeydetails(model);
                }
            }
        });
    }

    private void bindStateChangeKeyfileTypeSelection(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("keyfileType".equals(e.getPropertyName())) {
                KeyfileType keyfileType = (KeyfileType)e.getNewValue();
                if (keyfileType == null) {
                    this.setBackgroundToIndicateChoosability(false, this.outputTextSelectedFileActualKeyfile);
                    this.passwordFieldKeyentry.setEnabled(false);
                    this.inputTextKeyName.setEnabled(false);
                    this.btnSelectActualKeyfile.setEnabled(false);
                    this.btnAddKey.setEnabled(false);
                } else if (keyfileType.equals(KeyfileType.KEYFILE)) {
                    this.labelKeyfile.setText("Schl\u00fcsseldatei");
                    if (!KeyviewState.KEY_SELECTED.equals((Object)model.getKeyviewState())) {
                        this.passwordFieldKeystore.setText(null);
                        this.inputTextAlias.setText(null);
                        this.passwordFieldKeyentry.setText(null);
                        this.passwordFieldKeyentry.setEnabled(false);
                        this.inputTextKeyName.setEnabled(true);
                        this.btnSelectActualKeyfile.setEnabled(true);
                        this.btnAddKey.setEnabled(true);
                        this.setBackgroundToIndicateChoosability(true, this.outputTextSelectedFileActualKeyfile);
                    }
                } else if (keyfileType.equals(KeyfileType.KEYSTORE)) {
                    this.labelKeyfile.setText("Schl\u00fcsselcontainer");
                    if (!KeyviewState.KEY_SELECTED.equals((Object)model.getKeyviewState())) {
                        this.passwordFieldKeyentry.setEnabled(Keytype.PRIVATE.equals((Object)model.getSelectedKeytype()));
                        this.inputTextKeyName.setEnabled(true);
                        this.btnSelectActualKeyfile.setEnabled(true);
                        this.btnAddKey.setEnabled(true);
                        this.setBackgroundToIndicateChoosability(true, this.outputTextSelectedFileActualKeyfile);
                    }
                }
                boolean keystoreIsSelected = KeyfileType.KEYSTORE.equals(keyfileType);
                if (!KeyviewState.KEY_SELECTED.equals((Object)model.getKeyviewState())) {
                    this.enableKeystoreComponents(model, keystoreIsSelected);
                }
            }
        });
    }

    private void bindStateChangeAddedKeylist(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("privateKeyList".equals(e.getPropertyName())) {
                // empty if block
            }
        });
    }

    private void bindStateChangeKeyviewState(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("keyViewState".equals(e.getPropertyName())) {
                KeyviewState newState = (KeyviewState)((Object)((Object)e.getNewValue()));
                if (KeyviewState.KEY_SELECTED.equals((Object)newState)) {
                    this.setEnablingStateOfKeymanagementElementsWhenKeySelected();
                    model.setKeyName(null);
                } else if (!KeyviewState.NEW_KEY_KEYTYPE_SELECTED.equals((Object)newState)) {
                    if (KeyviewState.NEW_KEY_KEYTYPE_UNSELECTED.equals((Object)newState)) {
                        this.comboBoxSelectKeyfileType.setEnabled(true);
                    } else if (KeyviewState.DEFAULT.equals((Object)newState)) {
                        this.clearKeydetails(model);
                        this.comboBoxSelectKeyfileType.setEnabled(false);
                        this.btnNewKey.setEnabled(true);
                    }
                }
            }
        });
    }

    private void bindStateChangePrivateKeystoreState(GPackerModel model) {
        model.addPropertyChangeListener(e -> {
            if ("privateKeystoreState".equals(e.getPropertyName())) {
                KeystoreState newValue = (KeystoreState)((Object)((Object)e.getNewValue()));
                KeystoreState oldValue = (KeystoreState)((Object)((Object)e.getOldValue()));
                this.imageIconCustomLock.switchTo(newValue);
                if (KeystoreState.UNLOCKED_PASSWORD_UNSET.equals((Object)newValue)) {
                    this.btnLockUnlockPrivateKeys.setText("Private Schl\u00fcssel sperren");
                    this.passwordFieldLockKeyStore.setEnabled(true);
                    this.passwordFieldLockKeystoreRepeat.setEnabled(true);
                    this.btnResetPassword.setEnabled(false);
                    this.btnDiscardKeys.setEnabled(false);
                    if (KeystoreState.UNLOCKED_PASSWORD_SET.equals((Object)oldValue)) {
                        this.enableKeymanagementElementsWhenUnocked();
                    }
                    this.resetKeyManagementStatusLabel(model, model.getSelectedKeytype());
                } else if (KeystoreState.UNLOCKED_PASSWORD_SET.equals((Object)newValue)) {
                    this.btnLockUnlockPrivateKeys.setText("Private Schl\u00fcssel sperren");
                    this.passwordFieldLockKeyStore.setEnabled(false);
                    this.passwordFieldLockKeystoreRepeat.setEnabled(false);
                    this.btnResetPassword.setEnabled(true);
                    this.btnDiscardKeys.setEnabled(false);
                    this.resetKeyManagementStatusLabel(model, model.getSelectedKeytype());
                    this.enableKeymanagementElementsWhenUnocked();
                } else if (KeystoreState.LOCKED.equals((Object)newValue)) {
                    this.btnLockUnlockPrivateKeys.setText("Private Schl\u00fcssel entsperren");
                    this.passwordFieldLockKeyStore.setEnabled(true);
                    this.passwordFieldLockKeystoreRepeat.setEnabled(false);
                    this.btnResetPassword.setEnabled(false);
                    this.btnDiscardKeys.setEnabled(true);
                    this.resetKeyManagementStatusLabel(model, model.getSelectedKeytype());
                    if (Keytype.PRIVATE.equals((Object)model.getSelectedKeytype())) {
                        this.disableKeymanagementElementsWhenLocked();
                    }
                } else if (KeystoreState.INACTIVE.equals((Object)newValue)) {
                    this.btnLockUnlockPrivateKeys.setEnabled(false);
                    this.passwordFieldLockKeyStore.setEnabled(false);
                    this.passwordFieldLockKeystoreRepeat.setEnabled(false);
                    this.btnResetPassword.setEnabled(false);
                    this.btnDiscardKeys.setEnabled(false);
                    this.btnNewKey.setEnabled(true);
                    this.resetKeyManagementStatusLabel(model, model.getSelectedKeytype());
                }
            }
        });
    }

    void switchToPrivateKeys(GPackerModel model) {
        this.updateAddedKeyComboBox(model, null);
        this.comboBoxSelectKeyfileType.removeAllItems();
        this.comboBoxSelectKeyfileType.addItem(KeyfileType.KEYFILE);
        this.comboBoxSelectKeyfileType.addItem(KeyfileType.KEYSTORE);
        this.resetKeyManagementfields(model);
        this.resetKeyManagementStatusLabel(model, Keytype.PRIVATE);
        model.setKeyfileType(null);
        this.comboBoxSelectKeyfileType.setEnabled(false);
        if (KeystoreState.LOCKED.equals((Object)model.getPrivateKeystoreState())) {
            this.disableKeymanagementElementsWhenLocked();
        } else {
            this.btnNewKey.setEnabled(true);
        }
    }

    void switchToPublicKeys(GPackerModel model) {
        this.updateAddedKeyComboBox(model, null);
        this.comboBoxSelectKeyfileType.removeAllItems();
        this.comboBoxSelectKeyfileType.addItem(KeyfileType.KEYFILE);
        this.resetKeyManagementfields(model);
        this.resetKeyManagementStatusLabel(model, Keytype.PUBLIC);
        model.setKeyfileType(null);
        this.comboBoxSelectKeyfileType.setEnabled(false);
        this.btnNewKey.setEnabled(true);
    }

    void newKey(GPackerModel model) {
        model.setKeyfileType(null);
        model.setKeyName(null);
        model.setKeyviewState(KeyviewState.NEW_KEY_KEYTYPE_UNSELECTED);
        this.comboBoxSelectKeyfileType.setEnabled(true);
        this.resetKeyManagementfields(model);
        if (model.getPublicKeysSelected()) {
            model.setKeyfileType(KeyfileType.KEYFILE);
        }
    }

    private void discardPrivateKeys(GPackerModel model) {
        KeystoreState state = model.getPrivateKeystoreState();
        if (KeystoreState.LOCKED.equals((Object)state)) {
            KeystoreOutput privOutput = this.privateKeystore.resetPrivateKeyStore();
            if (DefaultResult.TRUE.equals((Object)privOutput.getResult())) {
                model.setPrivateKeystoreState(KeystoreState.UNLOCKED_PASSWORD_UNSET);
                if (Keytype.PRIVATE.equals((Object)model.getSelectedKeytype())) {
                    this.btnNewKey.setEnabled(true);
                }
            }
            if (DefaultResult.ERROR.equals((Object)privOutput.getResult())) {
                GPackerPrivKeystoreDiscardPrivateKeysExceptionProcessor exceptionProcessor = new GPackerPrivKeystoreDiscardPrivateKeysExceptionProcessor(privOutput, this.consolePrinter::printErrln);
                ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
                this.privateKeystoreComponents.deactivatePrivateKeystore(model);
            }
        }
    }

    private void resetPassword(GPackerModel model) {
        KeystoreState state = model.getPrivateKeystoreState();
        if (KeystoreState.UNLOCKED_PASSWORD_SET.equals((Object)state)) {
            KeystoreOutput privOutput = this.privateKeystore.resetPassword();
            if (DefaultResult.TRUE.equals((Object)privOutput.getResult())) {
                model.setPasswordLockKeystore(null);
                model.setPrivateKeystoreState(KeystoreState.UNLOCKED_PASSWORD_UNSET);
            } else if (DefaultResult.ERROR.equals((Object)privOutput.getResult())) {
                GPackerPrivKeystoreResetPasswordExceptionProcessor exceptionProcessor = new GPackerPrivKeystoreResetPasswordExceptionProcessor(privOutput, this.consolePrinter::printErrln);
                ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
                this.privateKeystoreComponents.deactivatePrivateKeystore(model);
            }
        }
    }

    private void createUIComponents() {
        this.outputTextSelectedFileSelectionInput = this.createOutputTextField();
        this.outputTextSelectedFileSelectionOutput = this.createOutputTextField();
        this.setBackgroundToIndicateChoosability(true, this.outputTextSelectedFileSelectionInput);
        this.imageIconCustomLock = new ImageFontIconCustom(COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_RED, COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GREEN, COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GRAY, 30);
        this.imageIconCustomLock.switchTo(KeystoreState.LOCKED);
        this.textAreaOutputConsole = new JTextArea(10, 1);
        DefaultCaret caret = (DefaultCaret)this.textAreaOutputConsole.getCaret();
        caret.setUpdatePolicy(2);
        this.outputTextSelectedFileSelectionInputKMode = this.createOutputTextField();
        this.outputTextSelectedFileSelectionOutputKMode = this.createOutputTextField();
        this.setBackgroundToIndicateChoosability(true, this.outputTextSelectedFileSelectionInputKMode);
        this.outputTextSelectedFileActualKeyfile = this.createOutputTextField();
    }

    private JLabel createOutputTextField() {
        JLabel result = new JLabel();
        result.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        result.setOpaque(true);
        return result;
    }

    private void declareTagReferences(GPackerModel model) {
        this.selectionModelReferencesByTag.put(Tag.CARE_PROVIDER, new ModelReferences<Boolean>("selectedTagCareProvider", model::setSelectedTagCareProvider, model::isSelectedTagCareProvider));
        this.selectionModelReferencesByTag.put(Tag.QS_DATA, new ModelReferences<Boolean>("selectedTagQsData", model::setSelectedTagQsData, model::isSelectedTagQsData));
        this.selectionModelReferencesByTag.put(Tag.PATIENT, new ModelReferences<Boolean>("selectedTagPatient", model::setSelectedTagPatient, model::isSelectedTagPatient));
        this.selectionModelReferencesByTag.put(Tag.PATIENT_TX, new ModelReferences<Boolean>("selectedTagPatientTx", model::setSelectedTagPatientTx, model::isSelectedTagPatientTx));
        this.widgetsByTagSelectionCheckboxes.put(Tag.CARE_PROVIDER, this.checkBoxSelectTagCareProvider);
        this.widgetsByTagSelectionCheckboxes.put(Tag.QS_DATA, this.checkBoxSelectTagQsData);
        this.widgetsByTagSelectionCheckboxes.put(Tag.PATIENT, this.checkBoxSelectTagPatient);
        this.widgetsByTagSelectionCheckboxes.put(Tag.PATIENT_TX, this.checkBoxSelectTagPatientTx);
    }

    private void initRadioButtons() {
        this.privateOrPublicSelectionGroup = new ButtonGroup();
        this.privateOrPublicSelectionGroup.add(this.radioBtnPrivate);
        this.privateOrPublicSelectionGroup.add(this.radioBtnPublic);
    }

    private void initComboBoxes() {
        this.comboBoxMapSelectKeyTag = new HashMap<Tag, JComboBox>();
        this.comboBoxMapSelectKeyTag.put(Tag.QS_DATA, this.comboBoxSelectKeyForQsData);
        this.comboBoxMapSelectKeyTag.put(Tag.CARE_PROVIDER, this.comboBoxSelectKeyForCarePrv);
        this.comboBoxMapSelectKeyTag.put(Tag.PATIENT, this.comboBoxSelectKeyForPatient);
        this.comboBoxMapSelectKeyTag.put(Tag.PATIENT_TX, this.comboBoxSelectKeyForPatientTx);
        for (Map.Entry<Tag, JComboBox> entry : this.comboBoxMapSelectKeyTag.entrySet()) {
            JComboBox comboBoxEntry = entry.getValue();
            comboBoxEntry.setModel(this.createEnumComboBoxModelWithNullValues(new KeyBoxEntry[0]));
            comboBoxEntry.setRenderer(new DefaultFlexibleListCellRenderer(new DefaultDisplayValueRetrieverFunction()));
        }
        this.comboBoxSelectAction.setModel(this.createEnumComboBoxModelWithNullValues(Action.values()));
        this.comboBoxSelectAction.setRenderer(new DefaultFlexibleListCellRenderer(new DefaultDisplayValueRetrieverFunction()));
        this.comboBoxSelectProfile.setModel(this.createEnumComboBoxModelWithNullValues(Profile.values()));
        this.comboBoxSelectProfile.setRenderer(new DefaultFlexibleListCellRenderer(new DefaultDisplayValueRetrieverFunction()));
        this.comboBoxSelectProfile.setPrototypeDisplayValue(Profile.getProfileWithLongestLabel());
        this.comboBoxSelectActionKMode.setModel(this.createEnumComboBoxModelWithNullValues(Action.values()));
        this.comboBoxSelectActionKMode.setRenderer(new DefaultFlexibleListCellRenderer(new DefaultDisplayValueRetrieverFunction()));
        this.comboBoxSelectKeyKMode.setModel(this.createEnumComboBoxModelWithNullValues(new KeyBoxEntry[0]));
        this.comboBoxSelectKeyKMode.setRenderer(new DefaultFlexibleListCellRenderer(new DefaultDisplayValueRetrieverFunction()));
        this.comboBoxSelectAddedKeys.setModel(this.createEnumComboBoxModelWithNullValues(new KeyBoxEntry[0]));
        this.comboBoxSelectAddedKeys.setRenderer(new DefaultFlexibleListCellRenderer(new NeutralDisplayValueRetrieverFunction()));
        this.comboBoxSelectKeyfileType.setModel(this.createEnumComboBoxModelWithNullValues(KeyfileType.values()));
        this.comboBoxSelectKeyfileType.setRenderer(new DefaultFlexibleListCellRenderer(new DefaultDisplayValueRetrieverFunction()));
        this.comboBoxSelectKeyfileType.setPrototypeDisplayValue(KeyfileType.getKeyfileTypeWithLongestLabel());
    }

    private void initFileChoosers() {
        this.removeAllFileFiltersFromChooser(this.fileChooserInputFilePMode);
        this.fileChooserInputFilePMode.setFileSelectionMode(0);
        this.fileChooserInputFilePMode.addChoosableFileFilter(FileChooserFilters.INPUT_FILE);
        this.removeAllFileFiltersFromChooser(this.fileChooserOutputFolderPMode);
        this.fileChooserOutputFolderPMode.setFileSelectionMode(1);
        this.fileChooserOutputFolderPMode.addChoosableFileFilter(FileChooserFilters.OUTPUT_FOLDER);
        this.removeAllFileFiltersFromChooser(this.fileChooserInputFileKMode);
        this.fileChooserInputFileKMode.setFileSelectionMode(0);
        this.fileChooserInputFileKMode.addChoosableFileFilter(FileChooserFilters.INPUT_FILE);
        this.removeAllFileFiltersFromChooser(this.fileChooserOutputFolderKMode);
        this.fileChooserOutputFolderKMode.setFileSelectionMode(1);
        this.fileChooserOutputFolderKMode.addChoosableFileFilter(FileChooserFilters.OUTPUT_FOLDER);
    }

    private void initProgressBar() {
        this.progressBarExecutionProgress.setStringPainted(true);
    }

    private void setLabelsToMatchValidationMessagesOrBeingFrequent() {
        this.labelInputFile.setText("Eingabedatei");
        this.labelAction.setText("Aktion");
        this.labelProfile.setText("Profil/Rolle");
        this.labelOutputFolder.setText("Ausgabeordner");
        this.labelPassword.setText("Passwort");
        this.labelRegNo.setText("Registriernummer");
        this.btnOpenFolderInput.setText("Ordner \u00f6ffnen");
        this.btnOpenFolderOutput.setText("Ordner \u00f6ffnen");
    }

    private void nameWidgetsForClickRoboter() {
        this.btnExit.setName("N_BTN_EXIT");
        this.btnExecute.setName("N_BTN_EXECUTE");
        this.btnClearPreferences.setName("N_BTN_CLEAR_PREFS");
        this.btnSelectInput.setName("N_BTN_OPEN_FILE_CHOOSER_INPUT_FILE");
        this.btnSelectInputKMode.setName("N_BTN_OPEN_FILE_CHOOSER_INPUT_FILE_KMODE");
        this.btnSelectOutput.setName("N_BTN_OPEN_FILE_CHOOSER_OUTPUT_DIR");
        this.btnSelectActualKeyfile.setName("N_BTN_OPEN_FILE_CHOOSER_SELECT_ACTUAL_KEYFILE");
        this.btnNewKey.setName("N_BTN_NEW_KEY");
        this.btnAddKey.setName("N_BTN_ADD_KEY");
        this.btnSelectOutputKMode.setName("N_BTN_OPEN_FILE_CHOOSER_OUTPUT_DIR_KMODE");
        this.fileChooserInputFilePMode.setName("N_FILE_CHOOSER_INPUT_FILE");
        this.fileChooserInputFileKMode.setName("N_FILE_CHOOSER_INPUT_FILE_K_MODE");
        this.fileChooserOutputFolderPMode.setName("N_FILE_CHOOSER_OUTPUT_DIR");
        this.fileChooserActualKeyfile.setName("N_FILE_CHOOSER_ACTUAL_KEYFILE");
        this.fileChooserOutputFolderKMode.setName("N_FILE_CHOOSER_OUTPUT_DIR_K_MODE");
        this.comboBoxSelectAction.setName("N_COMBO_ACTION");
        this.comboBoxSelectProfile.setName("N_COMBO_ROLE");
        this.comboBoxSelectKeyfileType.setName("N_COMBO_SELECT_KEYFILE_TYPE");
        this.comboBoxSelectAddedKeys.setName("N_COMBO_SELECT_ADDED_KEYS");
        this.comboBoxSelectKeyForQsData.setName("N_COMBO_SELECT_KEY_FOR_QSDATA");
        this.comboBoxSelectKeyForCarePrv.setName("N_COMBO_SELECT_KEY_FOR_CARE_PRV");
        this.comboBoxSelectKeyForPatient.setName("N_COMBO_SELECT_KEY_FOR_PATIENT");
        this.comboBoxSelectKeyForPatientTx.setName("N_COMBO_SELECT_KEY_FOR_PATIENT_TX");
        this.comboBoxSelectActionKMode.setName("N_COMBO_SELECT_ACTION_KMODE");
        this.comboBoxSelectKeyKMode.setName("N_COMBO_SELECT_KEY_KMODE");
        this.inputTextTxEncryptionPassword.setName("N_INPUT_TEXT_TX_ENC_PASSWORD");
        this.inputTextRegistrationNumberPMode.setName("N_INPUT_TEXT_REG_NO");
        this.inputTextKeyName.setName("N_INPUT_TEXT_KEYNAME");
        this.checkBoxSelectOptionTxEncryption.setName("N_CHECKBOX_ENABLE_TX_ENCRYPITION");
        this.checkBoxSelectTagCareProvider.setName("N_CHECKBOX_TAG_CARE_PROVIDER");
        this.checkBoxSelectTagQsData.setName("N_CHECKBOX_TAG_QS_DATA");
        this.checkBoxSelectTagPatient.setName("N_CHECKBOX_TAG_PATIENT");
        this.checkBoxSelectTagPatientTx.setName("N_CHECKBOX_TAG_PATIENT_TX");
        this.tabbedPaneMode.setName("N_TABBED_PANE");
        this.radioBtnPublic.setName("N_RADIO_BTN_PUBLIC");
    }

    private void removeAllFileFiltersFromChooser(JFileChooser fileChooser) {
        fileChooser.resetChoosableFileFilters();
        for (FileFilter filter : fileChooser.getChoosableFileFilters()) {
            fileChooser.removeChoosableFileFilter(filter);
        }
    }

    private <T extends Labeled> DefaultComboBoxModel<T> createEnumComboBoxModelWithNullValues(T[] values) {
        int newLength = values.length + 1;
        ArrayList<T> valueList = new ArrayList<T>(newLength);
        valueList.add(null);
        valueList.addAll(Arrays.asList(values));
        return new DefaultComboBoxModel<Labeled>(valueList.toArray((Labeled[])Arrays.copyOf(values, newLength)));
    }

    private String produceFilenamePMode(GPackerModel model) {
        InputFiletype inputFiletype = model.getInputFileTypePMode();
        Profile profile = model.getProfile();
        boolean profileIsDatenflussprotokollStrukturabfrage = Profile.P_DATENFLUSSPROTOKOLL_STRUKTURABFRAGEN.equals(profile);
        if (InputFiletype.CERTIFICATE.equals((Object)inputFiletype)) {
            return GPackerConstants.FILE_NAME_PATTERN_CERT_ZIP_AES;
        }
        if (profileIsDatenflussprotokollStrukturabfrage) {
            return GPackerConstants.FILE_NAME_PATTERN_PMODE_NO_REG_NO_ZIP_AES;
        }
        return this.produceRegNoLabelText(model.getRegistrationNumberPMode());
    }

    private String produceRegNoLabelText(String regNo) {
        if (StringUtils.isNotBlank(regNo)) {
            return GPackerConstants.FILE_NAME_PATTERN_ZIP_AES.replace("<Registriernummer>", regNo);
        }
        return GPackerConstants.FILE_NAME_PATTERN_ZIP_AES;
    }

    private File getStartDirectoryAsFile(Supplier<File>[] startValueGetter) {
        File currentValue = null;
        if (startValueGetter != null) {
            for (Supplier<File> currentValueSupplier : startValueGetter) {
                if (currentValue != null) continue;
                currentValue = currentValueSupplier.get();
            }
        }
        File startDirectory = null;
        if (currentValue != null) {
            if ((currentValue = FileUtils.getExistingInHierarchy(currentValue)).isFile()) {
                startDirectory = currentValue.getParentFile();
            } else if (currentValue.isDirectory()) {
                startDirectory = currentValue;
            }
        }
        return startDirectory;
    }

    private void showFileChooser(JFileChooser fileChooser, Consumer<File> modelSetter, Supplier<File> ... startValueGetter) {
        fileChooser.setCurrentDirectory(this.getStartDirectoryAsFile(startValueGetter));
        fileChooser.showOpenDialog(fileChooser.getParent());
        File file = null;
        try {
            file = fileChooser.getSelectedFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file != null) {
            modelSetter.accept(file);
        }
    }

    private void setBackgroundToIndicateChoosability(Boolean isSelected, JLabel component) {
        component.setBackground(Boolean.TRUE.equals(isSelected) ? Color.WHITE : null);
    }

    private <T> void setUpComboBox(JComboBox comboBox, Iterable<T> items) {
        comboBox.removeAllItems();
        comboBox.addItem(null);
        items.forEach(i -> comboBox.addItem(i));
    }

    @Override
    public void showMsgPopup(String msg, MessageMode mode) {
        int jOptionPaneMode;
        if (mode == MessageMode.ERROR) {
            jOptionPaneMode = 0;
        } else if (mode == MessageMode.WARNING) {
            jOptionPaneMode = 2;
        } else {
            return;
        }
        JOptionPane.showMessageDialog(this.getPane(), msg, mode.getHeading(), jOptionPaneMode);
    }

    @Override
    public void showConfirmationPopup(String title, String question, Consumer<Void> action) {
        int result = JOptionPane.showConfirmDialog(this.getPane(), question, title, 0);
        if (result == 0) {
            action.accept(null);
        }
    }

    private void processKeyManagementStatus(GPackerModel model, KeymanagementStatusState state) {
        if (KeymanagementStatusState.PUBLIC_DEFAULT.equals((Object)state)) {
            this.labelKeymanagementStatus.setForeground(COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GREEN);
            this.labelKeymanagementStatus.setText(new KeyManagementStatusProducer(Keytype.PUBLIC, model.getKeyListSize()).defaultMessage());
        } else if (KeymanagementStatusState.PRIVATE_DEFAULT.equals((Object)state)) {
            this.labelKeymanagementStatus.setForeground(COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GREEN);
            this.labelKeymanagementStatus.setText(new KeyManagementStatusProducer(Keytype.PRIVATE, model.getKeyListSize()).defaultMessage());
        } else if (KeymanagementStatusState.PUBLIC_JUST_ADDED.equals((Object)state)) {
            this.labelKeymanagementStatus.setForeground(COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GREEN);
            this.labelKeymanagementStatus.setText(new KeyManagementStatusProducer(Keytype.PUBLIC, model.getKeyListSize()).addedKey(model.getNameOfLastAddedKey()));
        } else if (KeymanagementStatusState.PRIVATE_JUST_ADDED.equals((Object)state)) {
            this.labelKeymanagementStatus.setForeground(COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GREEN);
            this.labelKeymanagementStatus.setText(new KeyManagementStatusProducer(Keytype.PRIVATE, model.getKeyListSize()).addedKey(model.getNameOfLastAddedKey()));
        } else if (KeymanagementStatusState.PUBLIC_JUST_DELETED.equals((Object)state)) {
            this.labelKeymanagementStatus.setForeground(COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GREEN);
            this.labelKeymanagementStatus.setText(new KeyManagementStatusProducer(Keytype.PUBLIC, model.getKeyListSize()).deletedKey(model.getNameOfLastDeletedKey()));
        } else if (KeymanagementStatusState.PRIVATE_JUST_DELETED.equals((Object)state)) {
            this.labelKeymanagementStatus.setForeground(COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_GREEN);
            this.labelKeymanagementStatus.setText(new KeyManagementStatusProducer(Keytype.PRIVATE, model.getKeyListSize()).deletedKey(model.getNameOfLastDeletedKey()));
        } else if (KeymanagementStatusState.PRIVATE_TO_BE_UNLOCKED_OR_DISCARDED.equals((Object)state)) {
            this.labelKeymanagementStatus.setForeground(COLOR_FOR_LABEL_KEYMANAGEMENT_STATUS_RED);
            this.labelKeymanagementStatus.setText("Entsperren oder verwerfen Sie die privaten Schl\u00fcssel.");
        }
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPaine = new JPanel();
        this.contentPaine.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.tabbedPaneMode = new JTabbedPane();
        this.contentPaine.add((Component)this.tabbedPaneMode, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(15, 5, new Insets(0, 0, 0, 0), -1, -1));
        this.tabbedPaneMode.addTab("P-Mode", panel1);
        this.comboBoxSelectAction = new JComboBox();
        this.comboBoxSelectAction.setEnabled(false);
        panel1.add(this.comboBoxSelectAction, new GridConstraints(1, 2, 1, 1, 8, 0, 4, 0, null, null, null, 0, false));
        this.checkBoxSelectOptionTxEncryption = new JCheckBox();
        this.checkBoxSelectOptionTxEncryption.setEnabled(false);
        this.checkBoxSelectOptionTxEncryption.setText("Transportverschl\u00fcsselung");
        panel1.add((Component)this.checkBoxSelectOptionTxEncryption, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        panel2.setVisible(true);
        panel1.add((Component)panel2, new GridConstraints(4, 2, 1, 1, 8, 2, 0, 0, null, null, null, 0, false));
        this.labelRegNo = new JLabel();
        this.labelRegNo.setText("Registriernummer (f\u00fcr Dateiname)");
        panel2.add((Component)this.labelRegNo, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.inputTextRegistrationNumberPMode = new JTextField();
        this.inputTextRegistrationNumberPMode.setEnabled(false);
        panel2.add((Component)this.inputTextRegistrationNumberPMode, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null, 0, false));
        this.labelPassword = new JLabel();
        this.labelPassword.setText("Passwort");
        panel2.add((Component)this.labelPassword, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.inputTextTxEncryptionPassword = new JPasswordField();
        this.inputTextTxEncryptionPassword.setEnabled(false);
        panel2.add((Component)this.inputTextTxEncryptionPassword, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.labelFileNameToBeTxEncryptionPMode = new JLabel();
        this.labelFileNameToBeTxEncryptionPMode.setText("Registriernummer (f\u00fcr Dateiname)");
        this.labelFileNameToBeTxEncryptionPMode.setVisible(false);
        panel2.add((Component)this.labelFileNameToBeTxEncryptionPMode, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.btnSelectInput = new JButton();
        this.btnSelectInput.setText("...");
        panel1.add((Component)this.btnSelectInput, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(5, 2, 1, 1, 0, 2, 1, 4, new Dimension(-1, 20), new Dimension(-1, 20), new Dimension(-1, 20), 0, false));
        this.labelHeadingTagsAndKeyFiles = new JLabel();
        this.labelHeadingTagsAndKeyFiles.setText("Elemente und Schl\u00fcsseldateien (\u00f6ffentlich/privat)");
        panel1.add((Component)this.labelHeadingTagsAndKeyFiles, new GridConstraints(6, 0, 1, 4, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(11, 2, 1, 1, 0, 2, 1, 4, new Dimension(-1, 20), new Dimension(-1, 20), new Dimension(-1, 20), 0, false));
        this.btnSelectOutput = new JButton();
        this.btnSelectOutput.setEnabled(false);
        this.btnSelectOutput.setText("...");
        panel1.add((Component)this.btnSelectOutput, new GridConstraints(12, 3, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.comboBoxSelectProfile = new JComboBox();
        this.comboBoxSelectProfile.setEnabled(false);
        panel1.add(this.comboBoxSelectProfile, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.btnOpenFolderInput = new JButton();
        this.btnOpenFolderInput.setEnabled(false);
        this.btnOpenFolderInput.setText("Ordner \u00f6ffnen");
        panel1.add((Component)this.btnOpenFolderInput, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel1.add((Component)spacer3, new GridConstraints(13, 2, 1, 1, 0, 2, 1, 4, new Dimension(-1, 20), new Dimension(-1, 20), new Dimension(-1, 20), 0, false));
        this.outputTextSelectedFileSelectionOutput.setText("");
        panel1.add((Component)this.outputTextSelectedFileSelectionOutput, new GridConstraints(12, 2, 1, 1, 0, 3, 3, 3, new Dimension(0, -1), null, null, 0, false));
        this.outputTextSelectedFileSelectionInput.setHorizontalAlignment(2);
        this.outputTextSelectedFileSelectionInput.setText("");
        panel1.add((Component)this.outputTextSelectedFileSelectionInput, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, new Dimension(0, -1), null, null, 0, false));
        this.btnOpenFolderOutput = new JButton();
        this.btnOpenFolderOutput.setText("Ordner \u00f6ffnen");
        panel1.add((Component)this.btnOpenFolderOutput, new GridConstraints(12, 4, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.labelInputFile = new JLabel();
        this.labelInputFile.setText("Eingabedatei");
        panel1.add((Component)this.labelInputFile, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.labelAction = new JLabel();
        this.labelAction.setText("Aktion");
        panel1.add((Component)this.labelAction, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.labelProfile = new JLabel();
        this.labelProfile.setText("Profil/Rolle");
        panel1.add((Component)this.labelProfile, new GridConstraints(2, 1, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Optionen");
        panel1.add((Component)label1, new GridConstraints(3, 1, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.comboBoxSelectKeyForQsData = new JComboBox();
        this.comboBoxSelectKeyForQsData.setEnabled(false);
        panel1.add((Component)this.comboBoxSelectKeyForQsData, new GridConstraints(7, 2, 1, 1, 0, 1, 2, 0, null, new Dimension(100, -1), null, 0, false));
        this.comboBoxSelectKeyForCarePrv = new JComboBox();
        this.comboBoxSelectKeyForCarePrv.setEnabled(false);
        panel1.add((Component)this.comboBoxSelectKeyForCarePrv, new GridConstraints(8, 2, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.comboBoxSelectKeyForPatient = new JComboBox();
        this.comboBoxSelectKeyForPatient.setEnabled(false);
        panel1.add((Component)this.comboBoxSelectKeyForPatient, new GridConstraints(9, 2, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.comboBoxSelectKeyForPatientTx = new JComboBox();
        this.comboBoxSelectKeyForPatientTx.setEnabled(false);
        panel1.add((Component)this.comboBoxSelectKeyForPatientTx, new GridConstraints(10, 2, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.labelOutputFolder = new JLabel();
        this.labelOutputFolder.setText("Ausgabeordner");
        panel1.add((Component)this.labelOutputFolder, new GridConstraints(12, 1, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel3, new GridConstraints(10, 1, 1, 1, 0, 3, 0, 3, null, null, null, 0, false));
        this.checkBoxSelectTagPatientTx = new JCheckBox();
        this.checkBoxSelectTagPatientTx.setEnabled(false);
        this.checkBoxSelectTagPatientTx.setText("");
        panel3.add((Component)this.checkBoxSelectTagPatientTx, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("patient_tx");
        panel3.add((Component)label2, new GridConstraints(0, 1, 1, 1, 8, 2, 4, 0, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel4, new GridConstraints(9, 1, 1, 1, 0, 3, 0, 3, null, null, null, 0, false));
        this.checkBoxSelectTagPatient = new JCheckBox();
        this.checkBoxSelectTagPatient.setEnabled(false);
        this.checkBoxSelectTagPatient.setText("");
        panel4.add((Component)this.checkBoxSelectTagPatient, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("patient");
        panel4.add((Component)label3, new GridConstraints(0, 1, 1, 1, 8, 2, 4, 0, null, null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel5, new GridConstraints(8, 1, 1, 1, 0, 3, 0, 3, null, null, null, 0, false));
        this.checkBoxSelectTagCareProvider = new JCheckBox();
        this.checkBoxSelectTagCareProvider.setEnabled(false);
        this.checkBoxSelectTagCareProvider.setText("");
        panel5.add((Component)this.checkBoxSelectTagCareProvider, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setText("care_provider");
        panel5.add((Component)label4, new GridConstraints(0, 1, 1, 1, 8, 2, 2, 0, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel6, new GridConstraints(7, 1, 1, 1, 0, 3, 0, 3, null, null, null, 0, false));
        this.checkBoxSelectTagQsData = new JCheckBox();
        this.checkBoxSelectTagQsData.setEnabled(false);
        this.checkBoxSelectTagQsData.setText("");
        panel6.add((Component)this.checkBoxSelectTagQsData, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("qs_data");
        panel6.add((Component)label5, new GridConstraints(0, 1, 1, 1, 8, 2, 4, 0, null, null, null, 0, false));
        JPanel panel7 = new JPanel();
        panel7.setLayout(new GridLayoutManager(8, 6, new Insets(0, 0, 0, 0), -1, -1));
        this.tabbedPaneMode.addTab("K-Mode", panel7);
        this.btnSelectInputKMode = new JButton();
        this.btnSelectInputKMode.setEnabled(true);
        this.btnSelectInputKMode.setText("...");
        panel7.add((Component)this.btnSelectInputKMode, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 0, null, null, null, 0, false));
        JLabel label6 = new JLabel();
        label6.setText("Eingabedatei");
        panel7.add((Component)label6, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        JLabel label7 = new JLabel();
        label7.setText("Aktion");
        panel7.add((Component)label7, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        JLabel label8 = new JLabel();
        label8.setText("Ausgabeordner");
        panel7.add((Component)label8, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.btnSelectOutputKMode = new JButton();
        this.btnSelectOutputKMode.setEnabled(false);
        this.btnSelectOutputKMode.setText("...");
        panel7.add((Component)this.btnSelectOutputKMode, new GridConstraints(5, 4, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.btnOpenFolderInputKMode = new JButton();
        this.btnOpenFolderInputKMode.setEnabled(false);
        this.btnOpenFolderInputKMode.setText("Ordner \u00f6ffnen");
        panel7.add((Component)this.btnOpenFolderInputKMode, new GridConstraints(0, 5, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.btnOpenFolderOutputKMode = new JButton();
        this.btnOpenFolderOutputKMode.setText("Ordner \u00f6ffnen");
        panel7.add((Component)this.btnOpenFolderOutputKMode, new GridConstraints(5, 5, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.outputTextSelectedFileSelectionOutputKMode.setText("");
        panel7.add((Component)this.outputTextSelectedFileSelectionOutputKMode, new GridConstraints(5, 1, 1, 3, 0, 3, 4, 0, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        panel7.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        panel7.add((Component)spacer5, new GridConstraints(6, 0, 1, 1, 0, 0, 2, 1, null, new Dimension(105, -1), null, 0, false));
        Spacer spacer6 = new Spacer();
        panel7.add((Component)spacer6, new GridConstraints(7, 0, 1, 1, 1, 0, 1, 2, null, new Dimension(-1, 20), null, 0, false));
        this.outputTextSelectedFileSelectionInputKMode.setText("");
        panel7.add((Component)this.outputTextSelectedFileSelectionInputKMode, new GridConstraints(0, 1, 1, 3, 0, 3, 0, 0, null, null, null, 0, false));
        JLabel label9 = new JLabel();
        label9.setText("Schl\u00fcssel");
        panel7.add((Component)label9, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.comboBoxSelectKeyKMode = new JComboBox();
        this.comboBoxSelectKeyKMode.setEnabled(false);
        panel7.add((Component)this.comboBoxSelectKeyKMode, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.comboBoxSelectActionKMode = new JComboBox();
        this.comboBoxSelectActionKMode.setEnabled(false);
        panel7.add(this.comboBoxSelectActionKMode, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.labelFileNameLabelLabelKMode = new JLabel();
        this.labelFileNameLabelLabelKMode.setEnabled(true);
        this.labelFileNameLabelLabelKMode.setText("Dateiname");
        this.labelFileNameLabelLabelKMode.setVisible(false);
        panel7.add((Component)this.labelFileNameLabelLabelKMode, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        panel7.add((Component)spacer7, new GridConstraints(2, 3, 1, 1, 0, 0, 3, 1, null, new Dimension(400, -1), null, 0, false));
        Spacer spacer8 = new Spacer();
        panel7.add((Component)spacer8, new GridConstraints(3, 2, 1, 1, 0, 1, 3, 1, null, new Dimension(50, -1), null, 0, false));
        this.labelFileNameToBeTxEncryptionKMode = new JLabel();
        this.labelFileNameToBeTxEncryptionKMode.setText("T-<Zeitstempel>.zip.aes");
        this.labelFileNameToBeTxEncryptionKMode.setVisible(false);
        panel7.add((Component)this.labelFileNameToBeTxEncryptionKMode, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel8 = new JPanel();
        panel8.setLayout(new GridLayoutManager(13, 6, new Insets(0, 0, 0, 0), -1, -1));
        this.tabbedPaneMode.addTab("Schl\u00fcssel", panel8);
        JLabel label10 = new JLabel();
        label10.setText("Schl\u00fcsseldatei-Typ");
        panel8.add((Component)label10, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.comboBoxSelectKeyfileType = new JComboBox();
        panel8.add((Component)this.comboBoxSelectKeyfileType, new GridConstraints(5, 1, 1, 3, 8, 1, 2, 0, null, null, null, 0, false));
        this.labelKeyfile = new JLabel();
        this.labelKeyfile.setText("Schl\u00fcsseldatei");
        panel8.add((Component)this.labelKeyfile, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.btnSelectActualKeyfile = new JButton();
        this.btnSelectActualKeyfile.setEnabled(false);
        this.btnSelectActualKeyfile.setText("...");
        panel8.add((Component)this.btnSelectActualKeyfile, new GridConstraints(6, 4, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.btnOpenFolderActualKeyfile = new JButton();
        this.btnOpenFolderActualKeyfile.setEnabled(false);
        this.btnOpenFolderActualKeyfile.setText("Ordner \u00f6ffnen");
        panel8.add((Component)this.btnOpenFolderActualKeyfile, new GridConstraints(6, 5, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JLabel label11 = new JLabel();
        label11.setText("Passwort Keystore");
        panel8.add((Component)label11, new GridConstraints(7, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.passwordFieldKeystore = new JPasswordField();
        this.passwordFieldKeystore.setEnabled(false);
        panel8.add((Component)this.passwordFieldKeystore, new GridConstraints(7, 1, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        Spacer spacer9 = new Spacer();
        panel8.add((Component)spacer9, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JLabel label12 = new JLabel();
        label12.setText("Schl\u00fcssel-Alias");
        panel8.add((Component)label12, new GridConstraints(8, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.inputTextAlias = new JTextField();
        this.inputTextAlias.setEnabled(false);
        panel8.add((Component)this.inputTextAlias, new GridConstraints(8, 1, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label13 = new JLabel();
        label13.setText("Schl\u00fcsselname");
        panel8.add((Component)label13, new GridConstraints(11, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.inputTextKeyName = new JTextField();
        this.inputTextKeyName.setEnabled(false);
        this.inputTextKeyName.setText("");
        panel8.add((Component)this.inputTextKeyName, new GridConstraints(11, 1, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.btnAddKey = new JButton();
        this.btnAddKey.setEnabled(false);
        this.btnAddKey.setText(" Hinzuf\u00fcgen");
        panel8.add((Component)this.btnAddKey, new GridConstraints(11, 4, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JLabel label14 = new JLabel();
        label14.setText("Passwort Schl\u00fcssel");
        panel8.add((Component)label14, new GridConstraints(9, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer10 = new Spacer();
        panel8.add((Component)spacer10, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JLabel label15 = new JLabel();
        label15.setText("Hinzugef\u00fcgte Schl\u00fcssel");
        panel8.add((Component)label15, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.comboBoxSelectAddedKeys = new JComboBox();
        this.comboBoxSelectAddedKeys.setEnabled(false);
        panel8.add(this.comboBoxSelectAddedKeys, new GridConstraints(1, 1, 1, 3, 8, 1, 2, 0, null, null, null, 0, false));
        this.btnDeleteKeyFromList = new JButton();
        this.btnDeleteKeyFromList.setEnabled(false);
        this.btnDeleteKeyFromList.setText("L\u00f6schen");
        panel8.add((Component)this.btnDeleteKeyFromList, new GridConstraints(1, 4, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JLabel label16 = new JLabel();
        label16.setText("Status:");
        panel8.add((Component)label16, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.labelKeymanagementStatus = new JLabel();
        this.labelKeymanagementStatus.setForeground(new Color(-16732926));
        this.labelKeymanagementStatus.setText("Es wurde noch kein Schl\u00fcssel hinzugef\u00fcgt.");
        panel8.add((Component)this.labelKeymanagementStatus, new GridConstraints(2, 1, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label17 = new JLabel();
        label17.setText("Schl\u00fcssel mit obigen Details kann unter folgendem Namen der Schl\u00fcsselliste hinzugef\u00fcgt werden.");
        panel8.add((Component)label17, new GridConstraints(10, 1, 1, 3, 10, 0, 0, 0, null, null, null, 0, false));
        this.outputTextSelectedFileActualKeyfile.setEnabled(false);
        this.outputTextSelectedFileActualKeyfile.setText("");
        panel8.add((Component)this.outputTextSelectedFileActualKeyfile, new GridConstraints(6, 1, 1, 3, 0, 1, 2, 2, null, new Dimension(770, 20), null, 0, false));
        JLabel label18 = new JLabel();
        label18.setText("Schl\u00fcsseldetails:");
        panel8.add((Component)label18, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer11 = new Spacer();
        panel8.add((Component)spacer11, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.passwordFieldKeyentry = new JPasswordField();
        this.passwordFieldKeyentry.setEnabled(false);
        panel8.add((Component)this.passwordFieldKeyentry, new GridConstraints(9, 1, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.radioBtnPublic = new JRadioButton();
        this.radioBtnPublic.setText("\u00f6ffentlich");
        panel8.add((Component)this.radioBtnPublic, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JLabel label19 = new JLabel();
        label19.setText("Verwaltete Schl\u00fcsselart");
        panel8.add((Component)label19, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.radioBtnPrivate = new JRadioButton();
        this.radioBtnPrivate.setSelected(true);
        this.radioBtnPrivate.setText("privat");
        panel8.add((Component)this.radioBtnPrivate, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer12 = new Spacer();
        panel8.add((Component)spacer12, new GridConstraints(0, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.btnNewKey = new JButton();
        this.btnNewKey.setText("Neu");
        panel8.add((Component)this.btnNewKey, new GridConstraints(5, 4, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel9 = new JPanel();
        panel9.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPaine.add((Component)panel9, new GridConstraints(2, 0, 1, 1, 1, 1, 5, 5, null, null, null, 0, false));
        this.progressBarExecutionProgress = new JProgressBar();
        panel9.add((Component)this.progressBarExecutionProgress, new GridConstraints(0, 0, 1, 1, 0, 3, 4, 3, null, new Dimension(600, 25), null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        panel9.add((Component)scrollPane1, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, new Dimension(-1, 300), null, 0, false));
        this.textAreaOutputConsole = new JTextArea();
        this.textAreaOutputConsole.setEditable(false);
        scrollPane1.setViewportView(this.textAreaOutputConsole);
        JPanel panel10 = new JPanel();
        panel10.setLayout(new GridLayoutManager(3, 10, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPaine.add((Component)panel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label20 = new JLabel();
        label20.setText("Passwort");
        panel10.add((Component)label20, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.btnLockUnlockPrivateKeys = new JButton();
        this.btnLockUnlockPrivateKeys.setText("Private Schl\u00fcssel entsperren");
        panel10.add((Component)this.btnLockUnlockPrivateKeys, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, new Dimension(200, -1), null, 0, false));
        this.passwordFieldLockKeyStore = new JPasswordField();
        panel10.add((Component)this.passwordFieldLockKeyStore, new GridConstraints(0, 3, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label21 = new JLabel();
        label21.setText("Passwort Wdh.");
        panel10.add((Component)label21, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.btnResetPassword = new JButton();
        this.btnResetPassword.setText("Passwort zur\u00fccksetzen");
        panel10.add((Component)this.btnResetPassword, new GridConstraints(0, 7, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.btnDiscardKeys = new JButton();
        this.btnDiscardKeys.setText("Private Schl\u00fcssel verwerfen");
        panel10.add((Component)this.btnDiscardKeys, new GridConstraints(0, 8, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.passwordFieldLockKeystoreRepeat = new JPasswordField();
        panel10.add((Component)this.passwordFieldLockKeystoreRepeat, new GridConstraints(0, 5, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        Spacer spacer13 = new Spacer();
        panel10.add((Component)spacer13, new GridConstraints(0, 6, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.btnExecute = new JButton();
        this.btnExecute.setText("Ausf\u00fchren");
        panel10.add((Component)this.btnExecute, new GridConstraints(2, 7, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.btnClearConsole = new JButton();
        this.btnClearConsole.setText("Ausgabe leeren");
        panel10.add((Component)this.btnClearConsole, new GridConstraints(2, 8, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.btnExit = new JButton();
        this.btnExit.setText("Beenden");
        panel10.add((Component)this.btnExit, new GridConstraints(2, 9, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer14 = new Spacer();
        panel10.add((Component)spacer14, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 4, null, new Dimension(-1, 20), null, 0, false));
        panel10.add((Component)this.imageIconCustomLock, new GridConstraints(0, 0, 1, 1, 4, 0, 3, 3, null, new Dimension(40, -1), null, 0, false));
        this.btnClearPreferences = new JButton();
        this.btnClearPreferences.setText("Gespeicherte Einstellungen l\u00f6schen");
        panel10.add((Component)this.btnClearPreferences, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPaine;
    }

    public class PrivateKeystoreComponents {
        void initPrivateKeystoreComponents() {
            if (!GPackerView.this.privateKeystore.isActive()) {
                // empty if block
            }
        }

        void lockUnlockPrivateKeystoreSafe(GPackerModel model) {
            if (GPackerView.this.privateKeystore.isActive()) {
                this.lockUnlockPrivateKeystore(model);
            }
        }

        void lockUnlockPrivateKeystore(GPackerModel model) {
            KeystoreState state = model.getPrivateKeystoreState();
            Object recovered = null;
            if (KeystoreState.UNLOCKED_PASSWORD_UNSET.equals((Object)state) || KeystoreState.UNLOCKED_PASSWORD_SET.equals((Object)state)) {
                boolean locked = false;
                KeystoreOutput privKeystoreOutput = null;
                if (KeystoreState.UNLOCKED_PASSWORD_UNSET.equals((Object)state)) {
                    boolean passwordOk = GPackerView.this.checkIfLockingPasswordIsCorrect(model);
                    if (passwordOk) {
                        privKeystoreOutput = GPackerView.this.privateKeystore.lockKeystore(model.getPasswordLockKeystore());
                    }
                } else {
                    privKeystoreOutput = GPackerView.this.privateKeystore.lockKeystore();
                }
                if (privKeystoreOutput != null) {
                    if (DefaultResult.ERROR.equals((Object)privKeystoreOutput.getResult())) {
                        GPackerPrivKeystoreLockExceptionProcessor exceptionProcessor = new GPackerPrivKeystoreLockExceptionProcessor(privKeystoreOutput, GPackerView.this.consolePrinter::printErrln);
                        ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
                        this.deactivatePrivateKeystore(model);
                    }
                    locked = DefaultResult.TRUE.equals((Object)privKeystoreOutput.getResult());
                }
                if (locked) {
                    model.setPrivateKeystoreState(KeystoreState.LOCKED);
                    model.resetPrivateKeys();
                    if (Keytype.PRIVATE.equals((Object)model.getSelectedKeytype())) {
                        GPackerView.this.clearKeydetails(model);
                    }
                    GPackerView.this.resetKeyManagementStatusLabel(model, model.getSelectedKeytype());
                }
            } else if (KeystoreState.LOCKED.equals((Object)state)) {
                if (model.getPasswordLockKeystore() == null || model.getPasswordLockKeystore().isBlank()) {
                    GPackerView.this.showMsgPopup("Passwort zum Entsperren der privaten Schl\u00fcssel fehlt.", MessageMode.ERROR);
                } else {
                    UnlockOutput output = GPackerView.this.privateKeystore.unlockKeystore(model.getPasswordLockKeystore());
                    if (UnlockResult.INVALID_PASSWORD.equals((Object)output.getResult())) {
                        GPackerView.this.showMsgPopup("Passwort zum Entsperren der privaten Schl\u00fcssel ist falsch.", MessageMode.ERROR);
                    }
                    if (UnlockResult.OK.equals((Object)output.getResult())) {
                        KeylistOutput keylistOutput = GPackerView.this.privateKeystore.loadKeyContainer();
                        if (KeylistResult.SUCCESS.equals((Object)keylistOutput.getResult())) {
                            model.setPrivateKeylist(keylistOutput.getKeyList());
                            model.setPrivateKeystoreState(KeystoreState.UNLOCKED_PASSWORD_SET);
                        } else if (KeylistResult.ERROR.equals((Object)keylistOutput.getResult())) {
                            GPackerPrivKeystoreLoadKeysExceptionProcessor exceptionProcessor = new GPackerPrivKeystoreLoadKeysExceptionProcessor(keylistOutput, GPackerView.this.consolePrinter::printErrln);
                            ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
                            this.deactivatePrivateKeystore(model);
                        }
                    }
                    if (UnlockResult.ERROR.equals((Object)output.getResult())) {
                        GPackerPrivKeystoreUnlockExceptionProcessor exceptionProcessor = new GPackerPrivKeystoreUnlockExceptionProcessor(output, GPackerView.this.consolePrinter::printErrln);
                        ((AbstractGPackerExceptionProcessor)exceptionProcessor).process();
                        this.deactivatePrivateKeystore(model);
                    }
                }
            }
            model.setPasswordLockKeystore(null);
            model.setPasswordLockKeystoreRepeat(null);
            GPackerView.this.updateKeyComboBoxes(model);
            if (Keytype.PRIVATE.equals((Object)model.getSelectedKeytype())) {
                GPackerView.this.updateAddedKeyComboBox(model, null);
            }
        }

        boolean tryToRecover(GPackerModel model) {
            KeystoreOutput result = GPackerView.this.privateKeystore.resetPrivateKeyStore();
            if (DefaultResult.ERROR.equals((Object)result.getResult())) {
                GPackerPrivKeystoreResetExceptionProcessor exceptionProcessor = new GPackerPrivKeystoreResetExceptionProcessor(result, GPackerView.this.consolePrinter::printErrln);
                exceptionProcessor.process();
                GPackerView.this.privateKeystore.deactivate();
                model.setPrivateKeystoreState(KeystoreState.INACTIVE);
                return false;
            }
            return true;
        }

        void deactivatePrivateKeystore(GPackerModel model) {
            GPackerView.this.privateKeystore.resetPrivateKeyStore();
            GPackerView.this.privateKeystore.deactivate();
            model.setPrivateKeystoreState(KeystoreState.INACTIVE);
        }
    }

    public class DeleteKeyViewProcessor {
        public void updateComponents(GPackerModel model) {
            String selectedKeyName = model.getSelectedKeyname() != null ? model.getSelectedKeyname().getLabel() : null;
            model.setSelectedKeyname(null);
            GPackerView.this.updateKeyComboBoxes(model);
            GPackerView.this.updateAddedKeyComboBox(model, null);
            model.setNameOfLastDeletedKey(selectedKeyName);
            if (Keytype.PUBLIC.equals((Object)model.getSelectedKeytype())) {
                GPackerView.this.processKeyManagementStatus(model, KeymanagementStatusState.PUBLIC_JUST_DELETED);
            }
            if (Keytype.PRIVATE.equals((Object)model.getSelectedKeytype())) {
                GPackerView.this.processKeyManagementStatus(model, KeymanagementStatusState.PRIVATE_JUST_DELETED);
            }
            GPackerView.this.clearKeydetails(model);
        }
    }

    public class AddKeyViewProcessor {
        public boolean checkIfKeynameIsInvalidOrAlreadyAssignedOrKeyfileNotSpecified(GPackerModel model, String name) {
            KeyList keyList = model.getSelectedKeylist();
            if (name == null || name.isBlank()) {
                GPackerView.this.showMsgPopup("Der Schl\u00fcsselname darf nicht leer sein.", MessageMode.ERROR);
                return false;
            }
            if (name.length() > 100) {
                GPackerView.this.showMsgPopup("Der Schl\u00fcsselname darf nicht mehr als 100 Zeichen besitzen.", MessageMode.ERROR);
                return false;
            }
            if (!name.matches("[A-Za-z0-9_\\-]*")) {
                GPackerView.this.showMsgPopup("Der Schl\u00fcsselname darf nur aus den Zeichen 'A-Z','a-z','0-9','_' und '-' bestehen.", MessageMode.ERROR);
                return false;
            }
            if (keyList.getKeyByName(name) != null) {
                GPackerView.this.showMsgPopup("Unter dem Namen '" + name + "' ist bereits ein Schl\u00fcssel vorhanden.", MessageMode.ERROR);
                return false;
            }
            if (model.getActualSelectedKeyfile() == null) {
                GPackerView.this.showMsgPopup("Schl\u00fcsseldatei muss angegeben werden.", MessageMode.ERROR);
                return false;
            }
            String alias = model.getAliasKeyentry();
            if (KeyfileType.KEYSTORE.equals(model.getKeyfileType()) && (alias == null || alias.isBlank())) {
                GPackerView.this.showMsgPopup("Schl\u00fcssel-alias muss angegeben werden.", MessageMode.ERROR);
                return false;
            }
            return true;
        }

        public boolean checkIfPrivateKeystoreIsUnlocked(GPackerModel model) {
            if (KeystoreState.LOCKED.equals((Object)model.getPrivateKeystoreState())) {
                GPackerView.this.showMsgPopup("Bevor Sie neue priv. Schl\u00fcssel hinzuf\u00fcgen k\u00f6nnen, m\u00fcssen Sie die gespeicherten priv. Schl\u00fcssel entsperren oder verwerfen.", MessageMode.ERROR);
                return false;
            }
            return true;
        }

        public void createMsgForAddingKey(GPackerModel model, KeyAddResult result, KeyContainer keyContainer, Keytype type) {
            if (KeyAddResult.DOUBLE_KEY.equals((Object)result)) {
                KeyContainer presentKey = null;
                presentKey = type == Keytype.PUBLIC ? model.getPublicKeylist().getKeyByHash(keyContainer.getHash()) : model.getPrivateKeylist().getKeyByHash(keyContainer.getHash());
                GPackerView.this.showMsgPopup("Unter dem Namen '" + (presentKey != null ? presentKey.getName() : "") + "' ist bereits der gleiche Schl\u00fcssel vorhanden.", MessageMode.ERROR);
            }
        }

        public void updateComponents(GPackerModel model, KeyAddResult keyAddResult, String nameOfNewKey) {
            if (KeyAddResult.OK.equals((Object)keyAddResult)) {
                GPackerView.this.updateAddedKeyComboBox(model, nameOfNewKey);
                GPackerView.this.updateKeyComboBoxes(model);
                model.setKeyviewState(KeyviewState.KEY_SELECTED);
                model.setNameOfLastAddedKey(nameOfNewKey);
                if (Keytype.PUBLIC.equals((Object)model.getSelectedKeytype())) {
                    GPackerView.this.processKeyManagementStatus(model, KeymanagementStatusState.PUBLIC_JUST_ADDED);
                }
                if (Keytype.PRIVATE.equals((Object)model.getSelectedKeytype())) {
                    GPackerView.this.processKeyManagementStatus(model, KeymanagementStatusState.PRIVATE_JUST_ADDED);
                }
            }
        }

        public boolean tryToRecover(GPackerModel model) {
            return GPackerView.this.privateKeystoreComponents.tryToRecover(model);
        }
    }
}

