/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.iqtig.packer.gui.GPackerActionValues;
import org.iqtig.packer.gui.constants.Action;
import org.iqtig.packer.gui.constants.GPackerConstants;
import org.iqtig.packer.gui.constants.ProcessingMode;
import org.iqtig.packer.gui.constants.Profile;
import org.iqtig.packer.gui.constants.Tag;
import org.iqtig.packer.gui.keymanagement.KeyContainer;

public class GPackerInputValidator {
    public String validate(GPackerActionValues values) {
        boolean profileIsNotDatenflussprotokollStrukturabfrage;
        File inputFile = values.processingMode == ProcessingMode.PMODE ? values.inputFilePMode : values.inputFileKMode;
        File outputFolder = values.processingMode == ProcessingMode.PMODE ? values.outputFolderPMode : values.outputFolderKMode;
        Action action = values.processingMode == ProcessingMode.PMODE ? values.actionPMode : values.actionKMode;
        Profile profile = values.profile;
        if (inputFile == null) {
            return this.getMissingInputMessage("Eingabedatei");
        }
        if (outputFolder == null) {
            return this.getMissingInputMessage("Ausgabeordner");
        }
        boolean isNotXMLFile = !GPackerConstants.P_IS_XML_FILE.test(inputFile);
        boolean isNotZipAes = !GPackerConstants.P_IS_ZIP_AES.test(inputFile);
        boolean isNotCerFile = !GPackerConstants.P_IS_CER.test(inputFile);
        boolean bl = profileIsNotDatenflussprotokollStrukturabfrage = !Profile.P_DATENFLUSSPROTOKOLL_STRUKTURABFRAGEN.equals(profile);
        if (isNotXMLFile && isNotZipAes && isNotCerFile) {
            return this.getMissingInputMessage("eine Datei mit der Endung .xml, .cer oder .zip.aes");
        }
        if (action == null) {
            return this.getMissingInputMessage("Aktion");
        }
        if (values.processingMode == ProcessingMode.PMODE) {
            boolean isNotTxDecryptionWithoutContentDecryption;
            boolean bl2 = isNotTxDecryptionWithoutContentDecryption = values.actionPMode != Action.DECRYPT || !values.keysByTag.isEmpty() || !values.selectedOptionTxEncryption;
            if (values.profile == null && isNotTxDecryptionWithoutContentDecryption) {
                return this.getMissingInputMessage("Profil/Rolle");
            }
            if (Action.ENCRYPT == values.actionPMode && values.selectedOptionTxEncryption && StringUtils.isBlank(values.regNumber) && isNotCerFile && profileIsNotDatenflussprotokollStrukturabfrage) {
                return this.getMissingInputMessage("Registriernummer");
            }
            if (values.selectedOptionTxEncryption && StringUtils.isBlank(values.password)) {
                return this.getMissingInputMessage("Passwort");
            }
            if (isNotTxDecryptionWithoutContentDecryption) {
                if (values.keysByTag.isEmpty() && isNotCerFile && profileIsNotDatenflussprotokollStrukturabfrage) {
                    String prefix = values.actionPMode == Action.ENCRYPT ? "ver" : "ent";
                    return this.getMissingInputMessage(String.format("zu %sschl\u00fcsselnde XML-Elemente", prefix));
                }
                for (Map.Entry<Tag, KeyContainer> keyBySelectedTag : values.keysByTag.entrySet()) {
                    if (keyBySelectedTag.getValue() != null) continue;
                    return this.getMissingInputMessage(String.format("Schl\u00fcsseleintrag f\u00fcr <%s>", keyBySelectedTag.getKey().tagValue));
                }
            }
        } else if (values.processingMode == ProcessingMode.KMODE) {
            if (Action.ENCRYPT.equals(values.actionKMode) && values.publicKeyKMode == null) {
                return this.getMissingInputMessage(String.format("Schl\u00fcsseleintrag f\u00fcr Verschl\u00fcsselung", new Object[0]));
            }
            if (Action.DECRYPT.equals(values.actionKMode) && values.privateKeyKMode == null) {
                return this.getMissingInputMessage(String.format("Schl\u00fcsseleintrag f\u00fcr Entschl\u00fcsselung", new Object[0]));
            }
        }
        return null;
    }

    private String getMissingInputMessage(String missing) {
        return "Bitte " + missing + " angeben.";
    }
}

