/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.gui;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.iqtig.packer.gui.GPackerConsolePrinter;
import org.iqtig.packer.gui.GPackerModel;
import org.iqtig.packer.gui.comp.MessageMode;

public class GPackerConsolePrinterImpl
implements GPackerConsolePrinter {
    DateTimeFormatter dateFormatConsole;
    GPackerModel model;

    public GPackerConsolePrinterImpl(DateTimeFormatter dateFormatConsole, GPackerModel model) {
        this.dateFormatConsole = dateFormatConsole;
        this.model = model;
    }

    @Override
    public void println(String s) {
        SwingUtilities.invokeLater(() -> this.printlnInEdt(s));
    }

    @Override
    public void printlnInEdt(String s) {
        StringBuilder builder = new StringBuilder();
        String previousMessages = this.model.getConsoleText();
        if (StringUtils.isNotBlank(previousMessages)) {
            builder.append(previousMessages).append("\n");
        }
        builder.append(LocalDateTime.now().format(this.dateFormatConsole)).append("  ").append(s);
        this.model.setConsoleText(builder.toString());
    }

    @Override
    public void println(String s, MessageMode mode) {
        String extendedString = "***" + mode.getHeading() + ": " + s;
        this.println(extendedString);
    }

    @Override
    public void printErrln(String s) {
        this.println(s, MessageMode.ERROR);
    }
}

