/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.crypto.key.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.iqtig.crypto.key.interfaces.KeyUsageVerifier;
import org.iqtig.packer.shared.crypto.RSAModulus;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.xpacker.impl.keyverifier.KeyTagMap;
import org.iqtig.xpacker.impl.keyverifier.KeyTagMapInitializer;
import org.iqtig.xpacker.impl.keyverifier.RSAPublicKeyId;
import org.iqtig.xpacker.support.XmlSupport;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class KeyUsageVerifierImpl
implements KeyUsageVerifier {
    @Override
    public String getModulus(RSAPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "PublicKey ist null.");
        RSAModulus modulus = new RSAModulus(publicKey);
        return modulus.getUnsignedModulusBase64Encoded();
    }

    @Override
    public boolean keyHasBeenUsedForTagEncryption(InputStream xmlStream, RSAPublicKey publicKey, String tag) throws SAXException, XMLSecurityException {
        try {
            Document doc = XmlSupport.createDocumentFromIs(xmlStream);
            KeyTagMap map = new KeyTagMapInitializer(doc).readKeys();
            return map.keyIsUsedForTag(new RSAPublicKeyId(publicKey), tag);
        }
        catch (IOException e) {
            throw Errors.InputFileIOException.createInstance();
        }
        catch (ParserConfigurationException e) {
            throw Errors.XMLParserConfigurationException.createInstance();
        }
    }
}

