/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.crypto.key.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.iqtig.crypto.key.impl.IQTIGKeyGeneratorImpl;
import org.iqtig.crypto.key.impl.IQTIGKeyPairGeneratorImpl;
import org.iqtig.crypto.key.interfaces.IQTIGKeyGenerator;
import org.iqtig.crypto.key.interfaces.IQTIGKeyPairGenerator;
import org.iqtig.crypto.key.interfaces.KeyGetter;

public class KeyGetterImpl
implements KeyGetter {
    private final IQTIGKeyGenerator keyGenerator = new IQTIGKeyGeneratorImpl();
    private final IQTIGKeyPairGenerator keyPairGenerator = new IQTIGKeyPairGeneratorImpl();

    @Override
    public Key newSymmetricKey() {
        return this.keyGenerator.generateKey();
    }

    @Override
    public KeyPair newAsymmetricKey() {
        return this.keyPairGenerator.generateKey();
    }

    @Override
    public KeyPair readRSAKeyPair(InputStream inPublicKey, InputStream inPrivateKey) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, Base64DecodingException {
        PublicKey publicKey = this.readRSAPublicKey(inPublicKey);
        PrivateKey privateKey = this.readRSAPrivateKey(inPrivateKey);
        return new KeyPair(publicKey, privateKey);
    }

    @Override
    public PublicKey readRSAPublicKey(InputStream in) throws IOException, Base64DecodingException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] publicKeyBytes = this.getKeyBytes(in);
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpecX509);
    }

    @Override
    public PrivateKey readRSAPrivateKey(InputStream in) throws IOException, Base64DecodingException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] privateKeyBytes = this.getKeyBytes(in);
        PKCS8EncodedKeySpec keySpecPKCS = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpecPKCS);
    }

    private byte[] getKeyBytes(InputStream in) throws IOException, Base64DecodingException {
        byte[] keyBytes = this.readInputStreamToByteArray(in);
        try (PemReader pemReader = new PemReader(new StringReader(new String(keyBytes)));){
            PemObject pemObject = pemReader.readPemObject();
            if (Objects.nonNull(pemObject)) {
                byte[] byArray = pemObject.getContent();
                return byArray;
            }
            byte[] byArray = this.base64ToByteArray(keyBytes);
            return byArray;
        }
    }

    private byte[] base64ToByteArray(byte[] base64EncodedBytes) throws Base64DecodingException {
        return Base64.decode(base64EncodedBytes);
    }

    private byte[] readInputStreamToByteArray(InputStream inputStream) throws IOException {
        int read;
        int DEFAULT_BUFFER_SIZE = 8192;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = inputStream.read(buffer, 0, 8192)) >= 0) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }
}

