/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.sequence;

import java.util.ArrayList;
import java.util.List;
import org.iqtig.pruefprogramm.config.SystemConfiguration;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.sequence.Sequence;
import org.iqtig.pruefprogramm.status.FileStatus;
import org.iqtig.pruefprogramm.xml.sax.HeaderReader;
import org.iqtig.pruefprogramm.xml.sax.ValidationItemInserter;

public class XsdWriteSequence
implements Sequence {
    @Override
    public void run(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        sysConfig.getLogger().outlnWithTimeStamp("Schreibe Validierungsergebnis nach \"" + fileStatus.getFileConfig().outputFile.getAbsolutePath() + "\"...");
        if (!fileStatus.isCorrupted()) {
            HeaderReader.HeaderInformation headerInformation = HeaderReader.getHeaderInformation(fileStatus.getCurrentLocation());
            int currentValId = headerInformation.highestValId + 1;
            fileStatus.addValidationId(Integer.toString(currentValId));
            ArrayList<String> errorMessages = new ArrayList<String>();
            errorMessages.addAll(fileStatus.getSchemaErrors(5));
            errorMessages.addAll(fileStatus.getSchemaWarnings(5));
            String status = "OK";
            if (!fileStatus.getSchemaErrors().isEmpty() || !fileStatus.getHeaderSchemaErrors().isEmpty()) {
                status = "ERROR";
            } else if (!fileStatus.getSchemaWarnings().isEmpty()) {
                status = "WARNING";
            }
            List<String> errorItemStrings = ValidationItemInserter.getErrorItemStrings(errorMessages);
            String[] valItems = new String[]{ValidationItemInserter.getValItemString("Schema", errorItemStrings, status, currentValId, null, null)};
            ValidationItemInserter.insertValidationItems(fileStatus.getCurrentLocation(), fileStatus.getFileConfig().outputFile, valItems, sysConfig.provider);
            fileStatus.setCurrentLocation(fileStatus.getFileConfig().outputFile, this.getClass());
        }
    }

    @Override
    public void check(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
    }
}

