/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.sequence;

import java.util.ArrayList;
import org.iqtig.pruefprogramm.config.SystemConfiguration;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.sequence.Sequence;
import org.iqtig.pruefprogramm.status.FileStatus;
import org.iqtig.pruefprogramm.xml.html.ProtocolWriter;
import org.iqtig.pruefprogramm.xml.sax.ElementRemover;

public class ProtocolSequence
implements Sequence {
    @Override
    public void run(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
        sysConfig.getLogger().outlnWithTimeStamp("Erstelle \"" + fileStatus.getFileConfig().protocolFile.getAbsolutePath() + "\"...");
        if (fileStatus.isCorrupted()) {
            ArrayList<String> errorsAndWarnings = new ArrayList<String>();
            errorsAndWarnings.addAll(fileStatus.getSchemaErrors(5));
            errorsAndWarnings.addAll(fileStatus.getSchemaWarnings(5));
            ProtocolWriter.writeMiniProtocol("Schema", errorsAndWarnings, 1, fileStatus.getGuid(), fileStatus.getFileConfig().protocolFile, sysConfig.provider, "dataflow");
        } else {
            ElementRemover.removeElements(fileStatus.getCurrentLocation(), fileStatus.getFileConfig().protocolFile, sysConfig.provider, new String[]{"qs_data", "patient", "ds:KeyInfo"}, true);
        }
    }

    @Override
    public void check(FileStatus fileStatus, SystemConfiguration sysConfig) throws InternalException {
    }
}

