/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.config;

public class Provider {
    public final String address;
    public final String email;
    public final String fax;
    public final String function;
    public final String name;
    public final String phone;
    public final String registration;

    public Provider(String address, String email, String fax, String function, String name, String phone, String registration) {
        this.address = address;
        this.email = email;
        this.fax = fax;
        this.function = function;
        this.name = name;
        this.phone = phone;
        this.registration = registration;
    }

    public Provider() {
        this.address = "Address";
        this.email = "email@provider.de";
        this.fax = "123456789";
        this.function = "Bundesauswertestelle";
        this.name = "Name";
        this.phone = "123456789";
        this.registration = "RE1234";
    }

    public String validationProviderToString() {
        return this.validationProviderToString(false);
    }

    public String validationProviderToString(boolean isDocProvider) {
        String providerString = isDocProvider ? "<provider" : "<validation_provider";
        providerString = providerString + (this.address != null ? " address=\"" + this.address + "\"" : "");
        providerString = providerString + (this.email != null ? " email=\"" + this.email + "\"" : "");
        providerString = providerString + (this.fax != null ? " fax=\"" + this.fax + "\"" : "");
        providerString = providerString + (this.function != null ? " function=\"" + this.function + "\"" : "");
        providerString = providerString + (this.name != null ? " name=\"" + this.name + "\"" : "");
        providerString = providerString + (this.phone != null ? " phone=\"" + this.phone + "\"" : "");
        providerString = providerString + (this.registration != null ? " registration=\"" + this.registration.replace("&", "&amp;") + "\"" : "");
        providerString = providerString + (isDocProvider ? "></provider>" : "></validation_provider>");
        return providerString;
    }

    public static enum PropertyEnum {
        address("address"),
        email("email"),
        fax("fax"),
        function("function"),
        name("name"),
        phone("phone"),
        registration("registration");

        public final String defaultValue;

        private PropertyEnum(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

