/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.iqtig.errors.ErrorsFromDB;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.xml.ValidationErrorHandler;
import org.xml.sax.SAXException;

public abstract class XsdFunctions {
    private static final AbstractMap<String, Schema> schemaMap = new HashMap<String, Schema>();

    public static ValidationErrorHandler validate(File inputFile, Validator validator) {
        ValidationErrorHandler veh = null;
        try {
            veh = XsdFunctions.validate(new FileInputStream(inputFile), validator);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return veh;
    }

    public static ValidationErrorHandler validate(InputStream ins, Validator validator) {
        ValidationErrorHandler errorHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errorHandler);
        try {
            StreamSource source = new StreamSource(ins);
            validator.validate(source);
        }
        catch (Exception e) {
            errorHandler.addXmlError(e);
        }
        return errorHandler;
    }

    public static Validator getValidator(File xsdFile) throws InternalException {
        if (!xsdFile.exists() || !xsdFile.isFile()) {
            throw new InternalException(ErrorsFromDB.Datenpruefprogramm.XsdFileNotFound.createInstance());
        }
        if (schemaMap.get(xsdFile.getAbsolutePath()) != null) {
            return schemaMap.get(xsdFile.getAbsolutePath()).newValidator();
        }
        String schemaLang = "http://www.w3.org/2001/XMLSchema";
        try {
            SchemaFactory factory = SchemaFactory.newInstance(schemaLang, "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", ClassLoader.getSystemClassLoader());
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            Schema schema = factory.newSchema(new StreamSource(xsdFile));
            schemaMap.put(xsdFile.getAbsolutePath(), schema);
            return schema.newValidator();
        }
        catch (SAXException e) {
            throw new InternalException(e);
        }
    }
}

