/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.iqtig.errors.ErrorsFromDB;
import org.iqtig.param.BooleanParameter;
import org.iqtig.param.StringParameter;
import org.iqtig.pruefprogramm.GUI;
import org.iqtig.pruefprogramm.common.FileFunctions;
import org.iqtig.pruefprogramm.common.HtmlFunctions;
import org.iqtig.pruefprogramm.config.Configuration;
import org.iqtig.pruefprogramm.config.FileConfiguration;
import org.iqtig.pruefprogramm.config.SystemConfiguration;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.logging.ConsoleLogger;
import org.iqtig.pruefprogramm.logging.Logger;
import org.iqtig.pruefprogramm.sequence.SequenceEnum;
import org.iqtig.pruefprogramm.status.FileStatus;

public class Main
implements Runnable {
    public static final String NAME = "Datenpruefprogramm";
    public static final String VERSION = "4.3.2";
    private final SystemConfiguration sysConfig;
    private final List<FileConfiguration> fileConfigs;
    private final File outputFolder;

    public static void main(String[] args) {
        Logger logger = new ConsoleLogger();
        try {
            if (new BooleanParameter("-v", "--version").get(args)) {
                System.out.println("Datenpruefprogramm Version 4.3.2");
                return;
            }
            String configPath = new StringParameter("-c", "--config").get(args);
            boolean doSchemaVal = !new BooleanParameter("--no-schema-val").get(args);
            boolean doSpezVal = !new BooleanParameter("--no-spez-val").get(args);
            Configuration config = new Configuration(Configuration.getConfig(configPath, true), args);
            SystemConfiguration sysConfig = new SystemConfiguration(config.xslPath, config.xsdPath, config.provider, (Boolean)config.gui, doSpezVal, doSchemaVal);
            logger = sysConfig.getLogger();
            List<FileConfiguration> fileConfigs = FileConfiguration.getFileConfigs(FileFunctions.getInputFiles(new File(config.inputPath), config.recursive), config.outputPath, config.inputPath);
            new Main(sysConfig, fileConfigs, new File(config.outputPath)).runGui();
        }
        catch (InternalException e) {
            logger.printError(e.getiError());
        }
    }

    public Main(SystemConfiguration sysConfig, List<FileConfiguration> fileConfigs, File outputFolder) {
        this.sysConfig = sysConfig;
        this.fileConfigs = fileConfigs;
        this.outputFolder = outputFolder;
    }

    private void runGui() {
        if (this.sysConfig.gui) {
            GUI gui = new GUI();
            this.sysConfig.setLogger(gui);
            gui.start(this, NAME, VERSION);
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        try {
            Main.checkOutputDirectory(this.sysConfig, this.outputFolder);
            this.sysConfig.getLogger().outln();
            this.sysConfig.getLogger().outlnWithTimeStamp("Pruefvorgang wird gestartet...");
            SequenceEnum[] sequence = SequenceEnum.getCustomSequence(this.sysConfig.doSchemaVal, this.sysConfig.doSpezVal);
            List<FileStatus> fileStatuses = SequenceEnum.run(sequence, this.fileConfigs, this.sysConfig);
            this.sysConfig.getLogger().outln();
            File htmlProtocolDir = FileFunctions.getHtmlProtocolLocation(this.outputFolder);
            this.sysConfig.getLogger().outlnWithTimeStamp("Erstelle \"" + new File(htmlProtocolDir.getAbsolutePath(), "index.html") + "\"...");
            HtmlFunctions.printIndexHtml(fileStatuses, htmlProtocolDir);
            this.sysConfig.getLogger().outln();
            this.sysConfig.getLogger().outlnWithTimeStamp("Pruefvorgang abgeschlossen.\n");
            this.sysConfig.getLogger().outln("____________________\n");
        }
        catch (InternalException e) {
            if (e.getiError() != null) {
                this.sysConfig.getLogger().printError(e.getiError());
            }
            this.sysConfig.getLogger().outln("Fehler: " + e.getMessage());
        }
    }

    private static void checkOutputDirectory(SystemConfiguration sysConfig, File outputFolder) throws InternalException {
        if (outputFolder.exists()) {
            String outputPath = outputFolder.getAbsolutePath();
            String dateSuffix = new SimpleDateFormat("___yyyy-MM-dd'T'HHmmss").format(new Date());
            File oldOutput = new File(outputFolder.getAbsolutePath() + dateSuffix);
            sysConfig.getLogger().outlnWithTimeStamp("Der Ordner \"" + outputFolder.getName() + "\" existiert bereits und wird umbenannt in \"" + oldOutput.getName() + "\"");
            outputFolder.renameTo(oldOutput);
            if (new File(outputPath).exists()) {
                throw new InternalException(ErrorsFromDB.Datenpruefprogramm.RenameFolderFailed.createInstance(outputFolder.getName()));
            }
        }
    }
}

