/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.validation.Validator;
import org.iqtig.pruefprogramm.common.XsdFunctions;
import org.iqtig.pruefprogramm.config.Configuration;
import org.iqtig.pruefprogramm.config.FileConfiguration;
import org.iqtig.pruefprogramm.config.Provider;
import org.iqtig.pruefprogramm.config.SystemConfiguration;
import org.iqtig.pruefprogramm.error.InternalException;
import org.iqtig.pruefprogramm.sequence.SequenceEnum;
import org.iqtig.pruefprogramm.sequence.XslSequence;
import org.iqtig.pruefprogramm.status.FileStatus;
import org.iqtig.pruefprogramm.xml.ValidationErrorHandler;
import org.iqtig.pruefprogramm.xml.html.ProtocolWriter;
import org.iqtig.pruefprogramm.xml.protocol.ProtocolInformation;
import org.iqtig.pruefprogramm.xml.protocol.ProtocolReader;
import org.iqtig.pruefprogramm.xml.sax.ElementRemover;
import org.iqtig.pruefprogramm.xml.sax.HeaderReader;
import org.iqtig.pruefprogramm.xml.sax.ValidationItemInserter;
import org.w3c.dom.Document;

public class Api {
    public static FileStatus validate(File inputFile, File outputFile, File xsdFile, File xslFile, File protocolFile, File htmlFile, Provider provider) throws InternalException {
        boolean schemaVal = xsdFile != null;
        boolean writeSchemaVal = outputFile != null && xsdFile != null;
        boolean spezVal = outputFile != null && xslFile != null;
        boolean protocol = outputFile != null && protocolFile != null;
        boolean htmlProtocol = outputFile != null && htmlFile != null;
        SequenceEnum[] sequence = SequenceEnum.getCustomSequence(schemaVal, writeSchemaVal, spezVal, protocol, htmlProtocol);
        FileConfiguration fileConfig = new FileConfiguration(inputFile, outputFile, protocolFile, htmlFile);
        SystemConfiguration sysConfig = new SystemConfiguration(xslFile, xsdFile, provider, (Boolean)false, spezVal, schemaVal);
        sysConfig.getLogger().setSilent(true);
        return SequenceEnum.run(sequence, fileConfig, sysConfig);
    }

    public static FileStatus validate(File inputFile, File outputFile, File xsdFile, File xslFile, Provider provider) throws InternalException {
        return Api.validate(inputFile, outputFile, xsdFile, xslFile, null, null, provider);
    }

    public static ByteArrayOutputStream validate(InputStream ins, File xslFile, Provider provider) throws InternalException {
        SystemConfiguration sysConfig = new SystemConfiguration(xslFile, null, provider, (Boolean)false, true, false);
        Transformer mainTransformer = XslSequence.getTransformer(sysConfig);
        HeaderReader.HeaderInformation headerInformation = HeaderReader.getHeaderInformation(ins);
        int currentValId = headerInformation.highestValId + 1;
        mainTransformer.setParameter("validation_id", currentValId);
        try {
            ins.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return XslSequence.transform(ins, mainTransformer);
    }

    public static FileStatus schemaValidate(File inputFile, File xsdFile) throws InternalException {
        return Api.schemaValidate(inputFile, null, xsdFile, null);
    }

    public static FileStatus schemaValidate(File inputFile, File outputFile, File xsdFile, Provider provider) throws InternalException {
        return Api.validate(inputFile, outputFile, xsdFile, null, provider);
    }

    public static List<String> schemaValidate(InputStream ins, File xsdFile) {
        Validator validator = null;
        try {
            validator = XsdFunctions.getValidator(xsdFile);
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        ValidationErrorHandler validationErrorHandler = XsdFunctions.validate(ins, validator);
        return validationErrorHandler.getFatalErrorMessages();
    }

    public static Provider getProvider(File configFile) throws InternalException {
        return Configuration.getConfig((File)configFile).provider;
    }

    public static void removeElements(File inputFile, File outputFile, Provider provider, String[] elements) throws InternalException {
        ElementRemover.removeElements(inputFile, outputFile, provider, elements);
    }

    public static void removeElements(File inputFile, File outputFile, String[] elements) throws InternalException {
        Api.removeElements(inputFile, outputFile, null, elements);
    }

    public static void writeMiniProtocol(File outputFile, String valType, List<String> errorMessages, Provider provider, String feedbackRange, String guid) throws InternalException {
        ProtocolWriter.writeMiniProtocol(valType, errorMessages, 1, guid, outputFile, provider, feedbackRange);
    }

    public static HeaderReader.HeaderInformation getHeaderInformation(File file) throws InternalException {
        return HeaderReader.getHeaderInformation(file);
    }

    public static HeaderReader.HeaderInformation getHeaderInformation(InputStream ins) throws InternalException {
        return HeaderReader.getHeaderInformation(ins);
    }

    public static String getValItemString(String value, List<String> errorItems, String status, int valId, String cDate, String checkTool) {
        return ValidationItemInserter.getValItemString(value, errorItems, status, valId, cDate, checkTool);
    }

    public static List<String> getErrorItemStrings(List<String> errorMessages) {
        return ValidationItemInserter.getErrorItemStrings(errorMessages);
    }

    public static String getErrorItemString(String errorType, String ruleId, String ruleType, String list, String errorMessage) {
        return ValidationItemInserter.getErrorItemString(errorType, ruleId, ruleType, list, errorMessage);
    }

    public static void insertValidationItems(File inputFile, File outputFile, String[] valItems, Provider provider) throws InternalException {
        ValidationItemInserter.insertValidationItems(inputFile, outputFile, valItems, provider);
    }

    public static ByteArrayOutputStream insertValidationItemsStream(InputStream ins, String[] valItems, Provider provider) throws InternalException {
        return ValidationItemInserter.insertValidationItemsStream(ins, valItems, provider);
    }

    public static ProtocolInformation getProtocolInformation(File inputFile) throws InternalException {
        return ProtocolReader.getProtocolInformation(inputFile);
    }

    public static Document getMiniProtocol(String valType, List<String> errorMessages, String guid, Provider provider) throws InternalException {
        return ProtocolWriter.getMiniProtocol(valType, errorMessages, 1, guid, "dataflow", provider);
    }
}

