/*
 * Decompiled with CFR 0.152.
 */
package rsacryptcsvColumn;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import rsacryptcsvColumn.RSA;

public class RSACryptCSVColumn {
    private static String umlaut(String par, String zeile) {
        if (par.equals("-e")) {
            zeile = zeile.replaceAll("\u00e4", "@ae#").replaceAll("\u00f6", "@oe#").replaceAll("\u00fc", "@ue#").replaceAll("\u00c4", "@AE#").replaceAll("\u00d6", "@OE#").replaceAll("\u00dc", "@UE#").replaceAll("\u00df", "@ss#");
        } else if (par.equals("-d")) {
            zeile = zeile.replaceAll("@ae#", "\u00e4").replaceAll("@oe#", "\u00f6").replaceAll("@ue#", "\u00fc").replaceAll("@AE#", "\u00c4").replaceAll("@OE#", "\u00d6").replaceAll("@UE#", "\u00dc").replaceAll("@ss#", "\u00df");
        }
        return zeile;
    }

    public static void main(String[] args) {
        try {
            String pKey;
            BufferedReader inputReader;
            if (args[0].toLowerCase().equalsIgnoreCase("-version")) {
                System.out.println("1.1.5 22.05.2024");
                System.exit(0);
            }
            RSA rsa = new RSA();
            if (args[0].toLowerCase().equalsIgnoreCase("-genKey")) {
                BufferedWriter outputWriter;
                rsa.init();
                if (new File("PrivKeyCsv.txt").exists()) {
                    System.out.println("Da in diesem Ordner schon eine Datei mit Namen \"PrivKeyCsv.txt\" existiert, wird kein neuer privater Schl\u00fcssel generiert.\nDas Programm wird abgebrochen.");
                    System.exit(0);
                } else {
                    outputWriter = new BufferedWriter(new FileWriter("PrivKeyCsv.txt"));
                    outputWriter.write(rsa.getPrivKey());
                    outputWriter.close();
                    System.out.println("Die Datei \"PrivKeyCsv.txt\", die den privaten Schl\u00fcssel enth\u00e4lt, wurde erstellt.");
                }
                if (new File("PubKeyCsv.txt").exists()) {
                    System.out.println("Da in diesem Ordner schon eine Datei mit Namen \"PubKeyCsv.txt\" existiert, wird kein neuer \u00f6ffentlicher Schl\u00fcssel generiert");
                } else {
                    outputWriter = new BufferedWriter(new FileWriter("PubKeyCsv.txt"));
                    outputWriter.write(rsa.getPubKey());
                    outputWriter.close();
                    System.out.println("Die Datei \"PubKeyCsv.txt\", die den \u00f6ffentlichen Schl\u00fcssel enth\u00e4lt, wurde erstellt.");
                }
                System.exit(0);
            }
            if (new File("PrivKeyCsv.txt").exists()) {
                inputReader = new BufferedReader(new FileReader("PrivKeyCsv.txt"));
                pKey = inputReader.readLine();
                inputReader.close();
            } else {
                pKey = "";
            }
            if (args[0].toLowerCase().equals("-d") && pKey.trim().equals("")) {
                System.out.println("Der private Schl\u00fcssel \"PrivKeyCsv.txt\" konnte nicht gefunden werden. Daher wird das Programm hier abgebrochen.");
                System.exit(0);
            }
            rsa.setPrivKey(pKey);
            if (new File("PubKeyCsv.txt").exists()) {
                inputReader = new BufferedReader(new FileReader("PubKeyCsv.txt"));
                pKey = inputReader.readLine();
                inputReader.close();
            } else {
                pKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCeL6VbbfT9VG2dHdzDgvrfMrayS3AGXVgM1221iiHqDKxebD0qgY/qusZIewmlfV34U9x9M2mHwoaRQ5Huu4CrDaNBkIYBqQ2emQOuf7J9v3f5444xnFc8Jh2mtBmADr1T9Ri4EJfm58Qi2kZs7rY1Sh/p6tGswajHRKOrBpnlEwIDAQAB";
            }
            rsa.setPubKey(pKey);
            rsa.initFromStrings();
            int hv_arg = args[0].toLowerCase().equals("-d") ? 1 : 0;
            while (hv_arg < args.length) {
                String inputFilePath = args[hv_arg];
                String inputFileName = Paths.get(inputFilePath, new String[0]).getFileName().toString();
                if (!inputFileName.toUpperCase().contains("HEADER.")) {
                    String ordnerPfad = new File(args[hv_arg]).getParent();
                    inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(inputFilePath)), StandardCharsets.ISO_8859_1));
                    String lineSeparator = System.getProperty("line.separator");
                    String line1 = inputReader.readLine();
                    if (!args[0].toLowerCase().equals("-d") && line1.toUpperCase().endsWith(";@RSA#")) {
                        inputReader.close();
                        System.out.println("Da die Datei \"" + args[hv_arg] + "\" bereits verschl\u00fcsselt worden ist, wird das Programm hier abgebrochen.");
                        System.exit(0);
                    }
                    File tempDatei = new File(ordnerPfad, "temp.txt");
                    String outputFilePath = "temp.txt";
                    BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempDatei), StandardCharsets.ISO_8859_1));
                    String indizesCrypt = ";";
                    String fieldnamesCrypt = ";VORNAMEM;NAMEM;ADRESSZUSATZ;STRASSE;PLZ;ORT;TELEFON;MOBIL;VORNAMEK;NAMEK;KOMMSPRACHE;GESCHLECHTK;BEMERKUNGEN;";
                    String[] columns = line1.split(";", -1);
                    int hv_i = 0;
                    while (hv_i < columns.length) {
                        indizesCrypt = String.valueOf(indizesCrypt) + (fieldnamesCrypt.contains(";" + columns[hv_i].toUpperCase() + ";") || columns[hv_i].toUpperCase().startsWith("RSA_") ? String.valueOf(hv_i) + ";" : "");
                        ++hv_i;
                    }
                    if (args[0].toLowerCase().equals("-d")) {
                        outputWriter.write(String.valueOf(line1.replaceFirst(";@RSA#", "")) + lineSeparator);
                    } else {
                        outputWriter.write(String.valueOf(line1) + ";@RSA#" + lineSeparator);
                    }
                    while ((line1 = inputReader.readLine()) != null) {
                        if (!args[0].toLowerCase().equals("-d")) {
                            line1 = RSACryptCSVColumn.umlaut("-e", line1);
                        }
                        String line2 = "";
                        columns = line1.split(";", -1);
                        int hv_i2 = 0;
                        while (hv_i2 < columns.length) {
                            line2 = String.valueOf(line2) + (!columns[hv_i2].trim().equals("") && indizesCrypt.contains(";" + hv_i2 + ";") ? (args[0].toLowerCase().equals("-d") ? (columns[hv_i2].length() == 172 ? rsa.decrypt(columns[hv_i2]) : columns[hv_i2]) : rsa.encrypt(columns[hv_i2])) : columns[hv_i2]) + (hv_i2 < columns.length - 1 ? ";" : "");
                            ++hv_i2;
                        }
                        if (args[0].toLowerCase().equals("-d")) {
                            line2 = RSACryptCSVColumn.umlaut("-d", line2);
                        }
                        outputWriter.write(String.valueOf(line2) + lineSeparator);
                    }
                    inputReader.close();
                    outputWriter.close();
                    File eingabeDatei = new File(args[hv_arg]);
                    eingabeDatei.delete();
                    tempDatei.renameTo(eingabeDatei);
                    System.out.println("Die Datei \"" + eingabeDatei + "\" wurde " + (args[0].toLowerCase().equals("-d") ? "entschl\u00fcsselt." : "verschl\u00fcsselt."));
                }
                ++hv_arg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

