/*
 * Decompiled with CFR 0.152.
 */
package rsacryptcsvColumn;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class RSA {
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private String PRIVATE_KEY_STRING;
    private String PUBLIC_KEY_STRING;

    public void init() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024);
            KeyPair pair = generator.generateKeyPair();
            this.privateKey = pair.getPrivate();
            this.publicKey = pair.getPublic();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void setPrivKey(String privKey) {
        this.PRIVATE_KEY_STRING = privKey;
    }

    public void setPubKey(String pubKey) {
        this.PUBLIC_KEY_STRING = pubKey;
    }

    public String getPrivKey() {
        return RSA.encode(this.privateKey.getEncoded());
    }

    public String getPubKey() {
        return RSA.encode(this.publicKey.getEncoded());
    }

    public void initFromStrings() {
        try {
            X509EncodedKeySpec keySpecPublic = new X509EncodedKeySpec(RSA.decode(this.PUBLIC_KEY_STRING));
            PKCS8EncodedKeySpec keySpecPrivate = new PKCS8EncodedKeySpec(RSA.decode(this.PRIVATE_KEY_STRING));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.publicKey = keyFactory.generatePublic(keySpecPublic);
            this.privateKey = keyFactory.generatePrivate(keySpecPrivate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printKeys() {
        System.err.println("Public key\n" + RSA.encode(this.publicKey.getEncoded()));
        System.err.println("Private key\n" + RSA.encode(this.privateKey.getEncoded()));
    }

    public String encrypt(String message) throws Exception {
        byte[] messageToBytes = message.getBytes();
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, this.publicKey);
        byte[] encryptedBytes = cipher.doFinal(messageToBytes);
        return RSA.encode(encryptedBytes);
    }

    private static String encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    private static byte[] decode(String data) {
        return Base64.getDecoder().decode(data);
    }

    public String decrypt(String encryptedMessage) throws Exception {
        byte[] encryptedBytes = RSA.decode(encryptedMessage);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, this.privateKey);
        byte[] decryptedMessage = cipher.doFinal(encryptedBytes);
        return new String(decryptedMessage, "UTF8");
    }
}

