/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.params;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.iqtig.packer.shared.cli.CliParam;
import org.iqtig.packer.shared.cli.CliParamParser;
import org.iqtig.xpacker.constants.Constants;
import org.iqtig.xpacker.error.IqtigError;
import org.iqtig.xpacker.params.XPackerCliParam;

public class XPackerCliParamInput {
    private final boolean help;
    private final boolean encypt;
    private final boolean decypt;
    private final boolean genKey;
    private final boolean getModulus;
    private final boolean checkKey;
    private final List<String> tags;
    private final String xmlInFileName;
    private final String xmlOufFileName;
    private final List<String> keyNames;
    private final String encryptedKeyTag;

    public XPackerCliParamInput(String[] args) {
        List<String> argList = Arrays.asList(args);
        Function<CliParam, RuntimeException> missingArgsExceptionProvider = i -> new IqtigError(Constants.getString("error.optionens.params1") + " \"" + i.getShortParam() + "\" " + Constants.getString("error.optionens.params2"));
        this.help = CliParamParser.option(argList, XPackerCliParam.HELP);
        this.encypt = CliParamParser.option(argList, XPackerCliParam.ENCRYPT);
        this.decypt = CliParamParser.option(argList, XPackerCliParam.DECRYPT);
        this.genKey = CliParamParser.option(argList, XPackerCliParam.GENERATE_KEY);
        this.getModulus = CliParamParser.option(argList, XPackerCliParam.GET_MODULUS);
        this.checkKey = CliParamParser.option(argList, XPackerCliParam.CHECK_KEY);
        this.keyNames = CliParamParser.optionWithParams(argList, XPackerCliParam.KEY_NAMES, missingArgsExceptionProvider);
        this.tags = CliParamParser.optionWithParams(argList, XPackerCliParam.TAGS, missingArgsExceptionProvider);
        this.xmlInFileName = CliParamParser.optionWithParam(argList, XPackerCliParam.INPUT_FILE, missingArgsExceptionProvider);
        this.xmlOufFileName = CliParamParser.optionWithParam(argList, XPackerCliParam.OUTPUT_FILE, missingArgsExceptionProvider);
        String value = CliParamParser.optionWithParam(argList, XPackerCliParam.ENCRYPTED_KEY_TAG, missingArgsExceptionProvider);
        this.encryptedKeyTag = value == null ? "encryption" : value;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isEncypt() {
        return this.encypt;
    }

    public boolean isDecypt() {
        return this.decypt;
    }

    public boolean isGenKey() {
        return this.genKey;
    }

    public boolean isGetModulus() {
        return this.getModulus;
    }

    public boolean isCheckKey() {
        return this.checkKey;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getXmlInFileName() {
        return this.xmlInFileName;
    }

    public String getXmlOufFileName() {
        return this.xmlOufFileName;
    }

    public List<String> getKeyNames() {
        return this.keyNames;
    }

    public String getEncryptedKeyTag() {
        return this.encryptedKeyTag;
    }
}

