/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.impl.keyverifier;

import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import org.iqtig.packer.shared.error.crypto.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyTagMapInitializerHelper {
    public static List<KeyTagIdPair> readKeys(Document document) throws XMLSecurityException {
        ArrayList<KeyTagIdPair> result = new ArrayList<KeyTagIdPair>();
        NodeList keyInfoElements = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        XMLCipher cipher = KeyTagMapInitializerHelper.initCipher();
        for (int i = 0; i < keyInfoElements.getLength(); ++i) {
            KeyTagIdPair keyTagIdPair = new KeyTagIdPair();
            Element keyInfoElement = (Element)keyInfoElements.item(i);
            keyTagIdPair.key = KeyTagMapInitializerHelper.extractPublicKey(keyInfoElement);
            keyTagIdPair.tag = KeyTagMapInitializerHelper.extractTagString(keyInfoElement, cipher);
            if (StringUtils.isBlank(keyTagIdPair.tag) || keyTagIdPair.key == null) continue;
            result.add(keyTagIdPair);
        }
        return result;
    }

    private static XMLCipher initCipher() throws XMLEncryptionException {
        Init.init();
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, null);
        return xmlCipher;
    }

    private static RSAPublicKey extractPublicKey(Element keyInfoElement) throws XMLSecurityException {
        KeyInfo keyInfo = new KeyInfo(keyInfoElement, null);
        RSAKeyValueResolver rsaKeyValueResolver = new RSAKeyValueResolver();
        keyInfo.registerInternalKeyResolver(rsaKeyValueResolver);
        return (RSAPublicKey)keyInfo.getPublicKey();
    }

    private static String extractTagString(Element keyInfoElement, XMLCipher xmlCipher) throws XMLEncryptionException {
        for (Node child = keyInfoElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!"EncryptedKey".equals(child.getLocalName())) continue;
            Element encryptedKeyelement = (Element)child;
            EncryptedKey encKey = xmlCipher.loadEncryptedKey(encryptedKeyelement);
            return encKey.getId();
        }
        return null;
    }

    public static class KeyTagIdPair {
        RSAPublicKey key;
        String tag;
    }
}

