/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.core.impl.rpacker;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.iqtig.packer.shared.crypto.CryptographySupportShared;
import org.iqtig.packer.shared.error.crypto.CryptoException;

public class RPacker {
    private static final String UNHANDLED_EXCEPTION_MESSAGE = "Unhandled exception occurred.";

    public void encrypt(Path inputFile, Path outputDirectory, PublicKey publicKey) {
        try (InputStream inputStream = Files.newInputStream(inputFile, StandardOpenOption.READ);
             FileOutputStream outputStream = new FileOutputStream(outputDirectory.resolve(inputFile.getFileName()) + ".aes");){
            CryptographySupportShared crypographySupport = new CryptographySupportShared();
            crypographySupport.encrypt(inputStream, (OutputStream)outputStream, crypographySupport.createRandomAESSessionKey(), secretKey -> {
                try {
                    return crypographySupport.wrapSecretKey(secretKey, publicKey);
                }
                catch (CryptoException e) {
                    throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
        }
        catch (CryptoException e) {
            throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
        }
    }

    public void decrypt(Path inputFile, Path outputDirectory, PrivateKey privateKey) {
        try (InputStream inputStream = Files.newInputStream(inputFile, StandardOpenOption.READ);
             FileOutputStream outputStream = new FileOutputStream(outputDirectory.resolve(inputFile.getFileName().toString().replace(".aes", "")).toFile());){
            CryptographySupportShared crypographySupport = new CryptographySupportShared();
            crypographySupport.decrypt(inputStream, (OutputStream)outputStream, secretKey -> {
                try {
                    return crypographySupport.unwrapSecretKey(secretKey, privateKey);
                }
                catch (CryptoException e) {
                    throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
        }
        catch (CryptoException e) {
            throw new RuntimeException(UNHANDLED_EXCEPTION_MESSAGE, e);
        }
    }
}

