/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.core.impl.io;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.tpacker.core.impl.io.FileInputStreamContainer;

public class InputIOProvider
implements Closeable {
    private List<FileInputStreamContainer> inputList;

    public InputIOProvider() {
        this.inputList = new ArrayList<FileInputStreamContainer>();
    }

    public InputIOProvider(List<String> inFiles) throws IOException {
        this.inputList = this.getInputFiles(inFiles);
    }

    public List<FileInputStreamContainer> getFileInputStreamContainer() {
        return this.inputList;
    }

    public void reset() {
        this.inputList = new ArrayList<FileInputStreamContainer>();
    }

    public void addFileInputStreamContainer(String path, InputStream is) {
        FileInputStreamContainer fileInputStreamContainer = new FileInputStreamContainer(path, is);
        this.inputList.add(fileInputStreamContainer);
    }

    @Override
    public void close() throws IOException {
        boolean exceptionOccured = false;
        for (FileInputStreamContainer fic : this.inputList) {
            try {
                fic.getInputStream().close();
            }
            catch (IOException e) {
                exceptionOccured = true;
            }
        }
        if (exceptionOccured) {
            throw new IOException();
        }
    }

    private List<FileInputStreamContainer> getInputFiles(List<String> inFiles) throws IOException {
        ArrayList<FileInputStreamContainer> files = new ArrayList<FileInputStreamContainer>();
        for (String inFile : inFiles) {
            FileInputStream file;
            try {
                file = new FileInputStream(inFile);
            }
            catch (FileNotFoundException e) {
                this.close();
                Errors.InputFileIsMissing validationErrorException = Errors.InputFileIsMissing.createInstance();
                validationErrorException.setStackTrace(e.getStackTrace());
                throw validationErrorException;
            }
            files.add(new FileInputStreamContainer(inFile, file));
        }
        return files;
    }
}

