/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.core.impl.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.util.List;
import org.iqtig.tpacker.core.impl.TPackerUtil;
import org.iqtig.tpacker.core.impl.io.FileInputStreamContainer;
import org.iqtig.tpacker.core.impl.rpacker.RPacker;

public class HybridDecrypt {
    private static final String UNHANDLED_EXCEPTION_MESSAGE = "Unhandled exception occurred.";
    private static final String TMP_PREF = "tpacker_tmp";
    private static final String ENC_SUFF = ".aes";
    private final PrivateKey privateKey;

    public HybridDecrypt(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void decrypt(List<FileInputStreamContainer> fileContainer) throws IOException {
        for (FileInputStreamContainer fileCont : fileContainer) {
            File tmp = this.writeToTmpFile(fileCont);
            File dec = this.decrypt(tmp);
            FileInputStream fileInput = new FileInputStream(dec);
            fileCont.setInputStream(fileInput);
            this.removeAesFromFileName(fileCont);
        }
    }

    private File writeToTmpFile(FileInputStreamContainer fileBean) throws IOException {
        File tmpFile = Files.createTempFile(TMP_PREF, ENC_SUFF, new FileAttribute[0]).toFile();
        tmpFile.deleteOnExit();
        try (FileOutputStream outputStream = new FileOutputStream(tmpFile);
             InputStream is = fileBean.getInputStream();){
            TPackerUtil.writeDatas(fileBean, outputStream);
        }
        return tmpFile;
    }

    private File decrypt(File tmp) throws IOException {
        File tempDir = Files.createTempDirectory(TMP_PREF, new FileAttribute[0]).toFile();
        tempDir.deleteOnExit();
        RPacker rpacker = new RPacker();
        rpacker.decrypt(tmp.toPath(), tempDir.toPath(), this.privateKey);
        File tmpFile = tempDir.toPath().resolve(tmp.getName().replace(ENC_SUFF, "")).toFile();
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    private void removeAesFromFileName(FileInputStreamContainer fileBean) {
        String filePathWithoutAesAtTheEnd = fileBean.getName().replaceAll(".aes\\z", "");
        fileBean.setName(filePathWithoutAesAtTheEnd);
    }
}

