/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.packer.shared.crypto;

import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Objects;
import org.iqtig.packer.shared.util.NumberByteArray;

public class RSAModulus {
    private final NumberByteArray numberByteArray;

    public RSAModulus(RSAPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "RSAModulus kann nicht mit 'null' initialisiert werden.");
        this.numberByteArray = new NumberByteArray(publicKey.getModulus());
    }

    public String getUnsignedModulusBase64Encoded() {
        return Base64.getEncoder().encodeToString(this.numberByteArray.toUnsignedByteArray());
    }

    public String getSignedModulusBase64Encoded() {
        return Base64.getEncoder().encodeToString(this.numberByteArray.toSignedByteArray());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RSAModulus other = (RSAModulus)obj;
        return Objects.equals(this.numberByteArray, other.numberByteArray);
    }

    public int hashCode() {
        return this.numberByteArray.hashCode();
    }
}

