/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.iqtig.tpacker.cli.Configuration;
import org.iqtig.tpacker.cli.impl.ConfigurationImpl;
import org.iqtig.tpacker.cli.impl.TPacker;

public final class Api {
    private Api() {
    }

    public static void zip(List<File> in, File out, Boolean timeStamp) throws IOException {
        List<String> files = Api.getFiles(in);
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(false).hybridEncrypt(false).hybridDecrypt(false).zip(true).unzip(false).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(null).keyFile(null).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(timeStamp == null || timeStamp == false).safe(true).characterSetPasswordDecryptOfString(null).build();
        Api.go(configuration);
    }

    public static void unzip(List<File> in, File out) throws IOException {
        List<String> files = Api.getFiles(in);
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(false).hybridEncrypt(false).hybridDecrypt(false).zip(false).unzip(true).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(null).keyFile(null).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(false).safe(true).characterSetPasswordDecryptOfString(null).build();
        Api.go(configuration);
    }

    public static void encrypt(List<File> in, File out, String password, Boolean timeStamp) throws IOException {
        List<String> files = Api.getFiles(in);
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(true).decypt(false).hybridEncrypt(false).hybridDecrypt(false).zip(false).unzip(false).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(password).keyFile(null).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(timeStamp == null || timeStamp == false).safe(true).characterSetPasswordDecryptOfString(null).build();
        Api.go(configuration);
    }

    public static void hybridEncrypt(List<File> in, File out, File keyFile, Boolean timeStamp) throws IOException {
        List<String> files = Api.getFiles(in);
        String keyFileString = keyFile.getAbsolutePath();
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(false).hybridEncrypt(true).hybridDecrypt(false).zip(false).unzip(false).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(null).keyFile(keyFileString).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(timeStamp == null || timeStamp == false).safe(true).characterSetPasswordDecryptOfString(null).build();
        Api.go(configuration);
    }

    public static void decrypt(List<File> in, File out, String password) throws IOException {
        Api.decrypt(in, out, password, null);
    }

    public static void decrypt(List<File> in, File out, String password, Charset characterSetPasswordDecrypt) throws IOException {
        List<String> files = Api.getFiles(in);
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(true).hybridEncrypt(false).hybridDecrypt(false).zip(false).unzip(false).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(password).keyFile(null).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(true).safe(true).characterSetPasswordDecrypt(characterSetPasswordDecrypt).build();
        Api.go(configuration);
    }

    public static void hybridDecrypt(List<File> in, File out, File keyFile) throws IOException {
        List<String> files = Api.getFiles(in);
        String keyFileString = keyFile.getAbsolutePath();
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(false).hybridEncrypt(false).hybridDecrypt(true).zip(false).unzip(false).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(null).keyFile(keyFileString).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(true).safe(true).characterSetPasswordDecryptOfString(null).build();
        Api.go(configuration);
    }

    public static void hybridDecrypt(List<File> in, File out, File keyStoreFile, String keyAlias, String keyStorePassword, String keyEntryPassword) throws IOException {
        List<String> files = Api.getFiles(in);
        String keyStoreFileString = keyStoreFile.getAbsolutePath();
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(false).hybridEncrypt(false).hybridDecrypt(true).zip(false).unzip(false).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(null).keyFile(null).pKCS12File(keyStoreFileString).keystorePassword(keyStorePassword).keyentryPassword(keyEntryPassword).keyentryAlias(keyAlias).timestamp(true).safe(true).characterSetPasswordDecryptOfString(null).build();
        Api.go(configuration);
    }

    public static void zipEncrypt(List<File> in, File out, String password, Boolean timeStamp) throws IOException {
        List<String> files = Api.getFiles(in);
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(true).decypt(false).hybridEncrypt(false).hybridDecrypt(false).zip(true).unzip(false).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(password).keyFile(null).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(timeStamp == null || timeStamp == false).safe(true).characterSetPasswordDecrypt(null).build();
        Api.go(configuration);
    }

    public static void zipHybridEncrypt(List<File> in, File out, File keyFile, Boolean timeStamp) throws IOException {
        Api.zipHybridEncrypt(in, out, keyFile, timeStamp, null);
    }

    public static void zipHybridEncrypt(List<File> in, File out, PublicKey publicKey, Boolean timeStamp) throws IOException {
        Api.zipHybridEncrypt(in, out, null, timeStamp, publicKey);
    }

    private static void zipHybridEncrypt(List<File> in, File out, File keyFile, Boolean timeStamp, PublicKey publicKey) throws IOException {
        List<String> files = Api.getFiles(in);
        String keyFileString = keyFile != null ? keyFile.getAbsolutePath() : null;
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(false).hybridEncrypt(true).hybridDecrypt(false).zip(true).unzip(false).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(null).keyFile(keyFileString).publicKey(publicKey).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(timeStamp == null || timeStamp == false).safe(true).characterSetPasswordDecryptOfString(null).build();
        Api.go(configuration);
    }

    public static void unzipDecrypt(List<File> in, File out, String password) throws IOException {
        Api.unzipDecrypt(in, out, password, null);
    }

    public static void unzipDecrypt(List<File> in, File out, String password, Charset characterSetPasswordDecrypt) throws IOException {
        List<String> files = Api.getFiles(in);
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(true).hybridEncrypt(false).hybridDecrypt(false).zip(false).unzip(true).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(password).keyFile(null).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(true).safe(true).characterSetPasswordDecrypt(characterSetPasswordDecrypt).build();
        Api.go(configuration);
    }

    public static void unzipHybridDecrypt(List<File> in, File out, File keyFile) throws IOException {
        Api.unzipHybridDecrypt(in, out, keyFile, null);
    }

    public static void unzipHybridDecrypt(List<File> in, File out, PrivateKey privateKey) throws IOException {
        Api.unzipHybridDecrypt(in, out, null, privateKey);
    }

    private static void unzipHybridDecrypt(List<File> in, File out, File keyFile, PrivateKey privateKey) throws IOException {
        List<String> files = Api.getFiles(in);
        String keyFileString = keyFile != null ? keyFile.getAbsolutePath() : null;
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(false).hybridEncrypt(false).hybridDecrypt(true).zip(false).unzip(true).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(null).keyFile(keyFileString).pKCS12File(null).keystorePassword(null).keyentryPassword(null).keyentryAlias(null).timestamp(true).safe(true).characterSetPasswordDecryptOfString(null).privateKey(privateKey).build();
        Api.go(configuration);
    }

    public static void unzipHybridDecrypt(List<File> in, File out, File keyStoreFile, String keyAlias, String keyStorePassword, String keyEntryPassword) throws IOException {
        List<String> files = Api.getFiles(in);
        String keyStoreFileString = keyStoreFile.getAbsolutePath();
        Configuration configuration = new ConfigurationImpl.ConfigurationBuilder().encypt(false).decypt(false).hybridEncrypt(false).hybridDecrypt(true).zip(false).unzip(true).determineEncryptionType(false).inFiles(files).out(out.getAbsolutePath() + (out.isDirectory() ? File.separator : "")).password(null).keyFile(null).pKCS12File(keyStoreFileString).keystorePassword(keyStorePassword).keyentryPassword(keyEntryPassword).keyentryAlias(keyAlias).timestamp(true).safe(true).characterSetPasswordDecryptOfString(null).build();
        Api.go(configuration);
    }

    private static List<String> getFiles(List<File> files) {
        ArrayList<String> filesList = new ArrayList<String>();
        for (File file : files) {
            filesList.add(file.getAbsolutePath());
        }
        return filesList;
    }

    private static void go(Configuration configuration) throws IOException {
        TPacker tPacker = new TPacker();
        tPacker.running(configuration);
    }
}

