/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.impl.sax;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.iqtig.xpacker.impl.sax.SaxHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ElementRecorder {
    private static StringBuffer elementBuffer = new StringBuffer();
    private static boolean recordElement = false;
    private static BufferedWriter out;
    private static String[] elementsToRecord;
    private static SaxHandler handler;
    private static final String[] xsiTypeReplacement;

    public static void setOutputFile(File outputFile) {
        try {
            if (outputFile.getParentFile() != null) {
                outputFile.getParentFile().mkdirs();
            }
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setHandler(SaxHandler newHandler) {
        handler = newHandler;
    }

    public static void setElementsToRecord(String[] newElementsToRecord) {
        elementsToRecord = newElementsToRecord;
    }

    public static String[] getElementsToRecord() {
        return elementsToRecord;
    }

    public static void closeOutputFile() {
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(String text) {
        try {
            if (recordElement) {
                elementBuffer.append(text);
            } else {
                out.write(text);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(char ch) {
        try {
            if (recordElement) {
                elementBuffer.append(ch);
            } else {
                out.write(ch);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void startRecording() {
        recordElement = true;
    }

    public static void stopRecording(String elementName) {
        recordElement = false;
        ElementRecorder.writeToFile(ElementRecorder.manipulateElement(elementBuffer, elementName));
        elementBuffer = new StringBuffer();
    }

    private static String manipulateElement(StringBuffer ElementBuffer, String elementName) {
        try {
            return handler.processDocument(ElementBuffer.toString(), elementName);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Document stringToDom(String docString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(docString.replaceFirst(xsiTypeReplacement[0], xsiTypeReplacement[1]))));
            return doc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String domToString(Document document) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StringWriter outWriter = new StringWriter();
            StreamResult result = new StreamResult(outWriter);
            transformer.transform(source, result);
            return outWriter.toString().replaceFirst(xsiTypeReplacement[1], xsiTypeReplacement[0]);
        }
        catch (Exception e) {
            System.err.println("Fehler beim Serialisieren des DOM-Baums");
            e.printStackTrace();
            return "";
        }
    }

    static {
        xsiTypeReplacement = new String[]{"xsi:type=\"", "xsi___type=\""};
    }
}

