/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker.config;

import java.util.ArrayList;
import java.util.List;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.packer.shared.error.ValidationErrorException;
import org.iqtig.xpacker.Configuration;

public class ConfigHelper {
    private final Configuration configuration;

    public ConfigHelper(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<ValidationErrorException> getParameterErrors() {
        ArrayList<ValidationErrorException> errors = new ArrayList<ValidationErrorException>();
        if (!(this.configuration.isEncrypt() || this.configuration.isDecrypt() || this.configuration.isGenKey() || this.configuration.isGetModulus() || this.configuration.isCheckKey())) {
            errors.add((ValidationErrorException)Errors.GenKeyAndEncryptAndDecryptAndGetModulusAndCheckKeyParamMissing.createInstance());
        }
        if (this.configuration.isEncrypt() && !this.isEncryptedKeyTag()) {
            errors.add((ValidationErrorException)Errors.GenKeyAndEncryptAndDecryptAndGetModulusAndCheckKeyParamMissing.createInstance());
        }
        if ((this.configuration.isEncrypt() || this.configuration.isDecrypt()) && !this.isTags()) {
            errors.add((ValidationErrorException)Errors.EncryptTagOrDecrpytTagIsMissing.createInstance());
        }
        if (this.configuration.getKeyNames().size() != 1) {
            errors.add((ValidationErrorException)Errors.OnlyOneKeyAllowed.createInstance());
        }
        return errors;
    }

    public String fileOnly(String name) {
        name = ConfigHelper.removePath(name, "/");
        name = ConfigHelper.removePath(name, "\\");
        return name;
    }

    public boolean checkParameter() {
        return this.getParameterErrors().isEmpty();
    }

    private static String removePath(String name, String toTest) {
        if (name.contains(toTest)) {
            name = name.substring(name.lastIndexOf(toTest) + 1);
        }
        return name;
    }

    public boolean isTags() {
        return this.configuration.getTags() != null && !this.configuration.getTags().isEmpty();
    }

    public boolean isEncryptedKeyTag() {
        return this.configuration.getEncryptedKeyTag() != null;
    }
}

