/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.xpacker;

import java.text.DecimalFormat;
import java.util.List;
import org.iqtig.packer.shared.cli.CliHelpAssembler;
import org.iqtig.packer.shared.cli.SystemExitWrapper;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.packer.shared.error.ValidationErrorException;
import org.iqtig.packer.shared.error.crypto.CryptoError;
import org.iqtig.packer.shared.error.crypto.CryptoException;
import org.iqtig.xpacker.Configuration;
import org.iqtig.xpacker.config.ConfigurationImpl;
import org.iqtig.xpacker.error.IqtigError;
import org.iqtig.xpacker.impl.XPacker;
import org.iqtig.xpacker.params.XPackerCliParam;
import org.iqtig.xpacker.params.XPackerCliParamInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPackerCliApp {
    private static final Logger LOG = LoggerFactory.getLogger(XPackerCliApp.class);
    private final SystemExitWrapper systemExitWrapper;

    public XPackerCliApp(SystemExitWrapper systemExitWrapper) {
        this.systemExitWrapper = systemExitWrapper;
    }

    public void start(String[] args) {
        int exitStatus = 0;
        try {
            XPackerCliParamInput inputParams = new XPackerCliParamInput(args);
            if (inputParams.isHelp()) {
                String helpText = CliHelpAssembler.assembleHelp((String)"XPacker", XPackerCliParam.valuesAsList());
                System.out.println(helpText);
            } else {
                Configuration executionParams = this.map(inputParams);
                new XPacker().running(executionParams);
            }
        }
        catch (ValidationErrorException e) {
            DecimalFormat i = new DecimalFormat("0000000");
            System.err.println("AQ" + i.format(e.getId()) + "\t" + e.getErrorMessage());
            exitStatus = 1;
        }
        catch (IqtigError e) {
            XPackerCliApp.handleError(e);
            exitStatus = 1;
        }
        catch (CryptoException cryptoException) {
            XPackerCliApp.handleError(cryptoException);
            exitStatus = 1;
        }
        catch (Exception e) {
            System.err.println(Errors.InternalErrorOccured.createInstance().getMessage());
            System.err.println(e.getMessage() + " " + e);
            LOG.error("Unbekannter Fehler", (Throwable)e);
            exitStatus = 1;
        }
        this.systemExitWrapper.exit(exitStatus);
    }

    private Configuration map(XPackerCliParamInput inputParams) {
        return new ConfigurationImpl.ConfigurationBuilder().encypt(inputParams.isEncypt()).decypt(inputParams.isDecypt()).genKey(inputParams.isGenKey()).getModulus(inputParams.isGetModulus()).checkKey(inputParams.isCheckKey()).xmlInFileName(inputParams.getXmlInFileName()).xmlOuFileName(inputParams.getXmlOufFileName()).keyNames(inputParams.getKeyNames()).tag(inputParams.getTags()).encryptedKeyTag(inputParams.getEncryptedKeyTag()).build();
    }

    public static void handleError(IqtigError e) {
        for (String error : e.getErrors()) {
            System.err.println(error);
        }
    }

    public static void handleError(CryptoException e) {
        List cryptoErrors = e.getErrors();
        for (int i = 0; i < cryptoErrors.size(); ++i) {
            System.err.print("Crypto-Error " + i + ":");
            System.err.println(((CryptoError)cryptoErrors.get(i)).getText());
        }
    }
}

