/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.crypto.key.impl;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.iqtig.crypto.key.impl.KeyGetterImpl;
import org.iqtig.crypto.key.interfaces.KeyGetter;
import org.iqtig.crypto.key.interfaces.MyPublicKey;
import org.iqtig.crypto.key.interfaces.XMLCryptionAsym;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.xpacker.impl.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLCryptionAsymImplOneKey
implements XMLCryptionAsym {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLCryptionAsymImplOneKey.class);
    private KeyGetter keyGetter;
    private final Status status;

    public XMLCryptionAsymImplOneKey(Status status) throws NoSuchAlgorithmException {
        if (!Init.isInitialized()) {
            Init.init();
        }
        this.keyGetter = new KeyGetterImpl();
        this.status = status;
    }

    public XMLCryptionAsymImplOneKey(Status status, KeyGetter keyGetter) throws NoSuchAlgorithmException {
        this(status);
        this.keyGetter = keyGetter;
    }

    @Override
    public Document encryptedXMLDoc(Document document, List<MyPublicKey> publicKeys, String tagName, String encryptedKeyTag) throws Exception {
        LOGGER.debug("encryptedXMLDoc f\u00fcr #{} Schl\u00fcssel, tag {}, encryptedKeyTag {}", new Object[]{publicKeys.size(), tagName, encryptedKeyTag});
        Key key = this.keyGetter.newSymmetricKey();
        for (MyPublicKey myPublicKey : publicKeys) {
            EncryptedKey encryptedKey = this.getEncryptedKey(document, myPublicKey.getPublicKey(), key);
            encryptedKey.setId(tagName);
            KeyInfo keyInfo = new KeyInfo(document);
            keyInfo.setId(myPublicKey.getKeyID());
            keyInfo.add(encryptedKey);
            keyInfo.add(myPublicKey.getPublicKey());
            NodeList list = document.getElementsByTagName(encryptedKeyTag);
            if (list == null || list.getLength() <= 0) {
                NodeList headerList = document.getElementsByTagName("header");
                if (headerList == null || headerList.getLength() <= 0) {
                    throw Errors.KeyTagIsMissing.createInstance((String)("header|" + encryptedKeyTag));
                }
                Element headerElement = (Element)headerList.item(0);
                Element newElement = document.createElement(encryptedKeyTag);
                headerElement.appendChild(newElement);
                list = document.getElementsByTagName(encryptedKeyTag);
            }
            Element keyElement = (Element)list.item(0);
            keyElement.insertBefore(keyInfo.getElement(), keyElement.getFirstChild());
        }
        NodeList encyptNodes = document.getElementsByTagName(tagName);
        int all = encyptNodes.getLength();
        LOGGER.debug("{}:{}", (Object)tagName, (Object)all);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        xmlCipher.init(1, key);
        xmlCipher.setSecureValidation(true);
        for (int i = 0; i < encyptNodes.getLength(); ++i) {
            Element encryptElement = (Element)encyptNodes.item(i);
            this.statusOut();
            xmlCipher.doFinal(document, encryptElement, true);
        }
        return document;
    }

    private void statusOut() {
        this.status.inc();
        LOGGER.debug("{}", (Object)this.status.percent());
    }

    @Override
    public Document decryptXMLDoc(Document document, List<PrivateKey> privateKeys, String tagname) throws Exception {
        List<Element> keyElements = this.getKeyElement(tagname, document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"), "Id");
        Key key = null;
        for (Element keyElement : keyElements) {
            for (PrivateKey privateKey : privateKeys) {
                try {
                    key = this.getKeyFromEncryptedKey(keyElement, privateKey);
                }
                catch (XMLEncryptionException e) {
                    LOGGER.debug("Tag: {} konnte nicht mit {} entschl\u00fcsselt werden", (Object)tagname, (Object)privateKey);
                }
            }
        }
        if (key == null && this.checkNodesForEncryptedContent(document, tagname)) {
            String detailMsg = "Entweder wurde kein Schluessel zur Entschluesselung von " + tagname + " gefunden oder der Schluessel konnte nicht mit dem privaten Schluessel entschluesselt werden.";
            throw Errors.DecryptionFailed.createInstance((String)tagname, (String)detailMsg);
        }
        for (Element element : keyElements) {
            Node parent = element.getParentNode();
            parent.getParentNode().removeChild(parent);
        }
        NodeList encyptTagNodes = document.getElementsByTagName(tagname);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        xmlCipher.init(2, key);
        xmlCipher.setSecureValidation(true);
        for (int i = 0; i < encyptTagNodes.getLength(); ++i) {
            Element encryptedElements = (Element)encyptTagNodes.item(i);
            NodeList encryptedNodes = encryptedElements.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            for (int j = 0; j < encryptedNodes.getLength(); ++j) {
                Element encryptedElement = (Element)encryptedNodes.item(j);
                try {
                    this.statusOut();
                    xmlCipher.doFinal(document, encryptedElement);
                    continue;
                }
                catch (XMLEncryptionException e) {
                    String details = "Errors.DataToEncryptAreCorrupt.createInstance(tagname)";
                    throw Errors.DecryptionFailed.createInstance((String)tagname, (String)details);
                }
            }
        }
        return document;
    }

    private boolean checkNodesForEncryptedContent(Document document, String tagName) {
        NodeList nodes = document.getElementsByTagName(tagName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element encyptedElements = (Element)nodes.item(i);
            NodeList encryptedNodes = encyptedElements.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            if (encryptedNodes.getLength() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<Element> getKeyElement(String tagName, NodeList nodeListKeys, String attribut) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodeListKeys.getLength(); ++i) {
            Element element = (Element)nodeListKeys.item(i);
            if (!element.getAttribute(attribut).equals(tagName)) continue;
            elements.add(element);
        }
        return elements;
    }

    private EncryptedKey getEncryptedKey(Document document, PublicKey publicKey, Key key) throws XMLEncryptionException {
        XMLCipher keyCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        keyCipher.init(3, (Key)publicKey);
        keyCipher.setSecureValidation(true);
        return keyCipher.encryptKey(document, key);
    }

    private Key getKeyFromEncryptedKey(Element element, PrivateKey privateKey) throws XMLEncryptionException {
        XMLCipher keyCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        keyCipher.init(4, (Key)privateKey);
        keyCipher.setSecureValidation(true);
        EncryptedKey encryptedKey = keyCipher.loadEncryptedKey(element);
        return keyCipher.decryptKey(encryptedKey, "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
    }
}

