/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.tpacker.cli.Configuration;
import org.iqtig.tpacker.cli.impl.TPackerUtil;
import picocli.CommandLine;

public class ParameterValidator {
    private final Configuration config;

    public ParameterValidator(Configuration config) {
        this.config = config;
    }

    public void validateInputFilesDoExist() {
        List<String> inFileStrings = this.config.getInFiles();
        for (String inFileString : inFileStrings) {
            if (Files.isDirectory(Paths.get(inFileString, new String[0]), new LinkOption[0])) {
                throw Errors.InputFileIsDirectory.createInstance();
            }
            if (Files.exists(Paths.get(inFileString, new String[0]), new LinkOption[0])) continue;
            throw Errors.InputFileIsMissing.createInstance();
        }
    }

    public void validateOutputDirIsPresent() {
        Path path = TPackerUtil.getOutputDir(this.config);
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            throw Errors.OutputDirectoryDoesNotExist.createInstance();
        }
    }

    public void validateEitherKeyFileOrStoreFileIsPresent(CommandLine.Model.CommandSpec spec) {
        if (this.isPresent(this.config.getKeyfile()) == this.isPresent(this.config.getPKCS12file())) {
            throw new CommandLine.ParameterException(spec.commandLine(), "Es muss entweder ein Keyfile (-k) oder ein PKCS12-Keystore-File (-s) angegeben werden.");
        }
    }

    public void validateWhenKeyFileIsPresentItDoesExist() {
        if (this.isPresent(this.config.getKeyfile()) && !Files.exists(Paths.get(this.config.getKeyfile(), new String[0]), new LinkOption[0])) {
            throw Errors.KeyFileNotFound.createInstance();
        }
    }

    public void validateWhenKeystoreFileIsPresentItDoesExist() {
        if (this.isPresent(this.config.getPKCS12file()) && !Files.exists(Paths.get(this.config.getPKCS12file(), new String[0]), new LinkOption[0])) {
            throw Errors.KeystoreFileNotFound.createInstance();
        }
    }

    private boolean isPresent(String s) {
        return s != null && !s.isEmpty();
    }
}

