/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli.impl;

import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import org.iqtig.tpacker.cli.Configuration;
import org.iqtig.tpacker.cli.error.IqtigError;
import org.iqtig.tpacker.cli.impl.Constants;

public class ConfigurationImpl
implements Configuration {
    private final boolean encypt;
    private final boolean decypt;
    private final boolean hybridEncrypt;
    private final boolean hybridDecrypt;
    private final boolean zip;
    private final boolean unzip;
    private final boolean determineEncryptionType;
    private final List<String> inFiles;
    private final String out;
    private final String password;
    private final String keyFile;
    private final String pKCS12File;
    private final String keystorePassword;
    private final String keyentryPassword;
    private final String keyentryAlias;
    private final boolean timeStamp;
    private final boolean safe;
    private final Charset characterSetPasswordDecrypt;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    public ConfigurationImpl(ConfigurationBuilder configBuilder) {
        this.encypt = configBuilder.encypt;
        this.decypt = configBuilder.decypt;
        this.hybridEncrypt = configBuilder.hybridEncrypt;
        this.hybridDecrypt = configBuilder.hybridDecrypt;
        this.zip = configBuilder.zip;
        this.unzip = configBuilder.unzip;
        this.determineEncryptionType = configBuilder.determineEncryptionType;
        this.inFiles = configBuilder.inFiles;
        this.out = configBuilder.out;
        this.password = configBuilder.password;
        this.keyFile = configBuilder.keyFile;
        this.pKCS12File = configBuilder.pKCS12File;
        this.keystorePassword = configBuilder.keystorePassword;
        this.keyentryPassword = configBuilder.keyentryPassword;
        this.keyentryAlias = configBuilder.keyentryAlias;
        this.timeStamp = configBuilder.timeStamp;
        this.safe = configBuilder.safe;
        this.characterSetPasswordDecrypt = configBuilder.characterSetPasswordDecrypt;
        this.privateKey = configBuilder.privateKey;
        this.publicKey = configBuilder.publicKey;
    }

    @Override
    public boolean isEncypt() {
        return this.encypt;
    }

    @Override
    public boolean isDecrypt() {
        return this.decypt;
    }

    @Override
    public boolean isHybridEncrypt() {
        return this.hybridEncrypt;
    }

    @Override
    public boolean isHybridDecrypt() {
        return this.hybridDecrypt;
    }

    @Override
    public boolean isZip() {
        return this.zip;
    }

    @Override
    public boolean isUnzip() {
        return this.unzip;
    }

    @Override
    public boolean isDetermineEncryptionType() {
        return this.determineEncryptionType;
    }

    @Override
    public List<String> getInFiles() {
        return this.inFiles;
    }

    @Override
    public String getOut() {
        String retur = "";
        if (this.out != null) {
            retur = this.out;
        }
        return retur;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getKeyfile() {
        return this.keyFile;
    }

    @Override
    public String getPKCS12file() {
        return this.pKCS12File;
    }

    @Override
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public String getKeyentryPassword() {
        return this.keyentryPassword;
    }

    @Override
    public String getKeyentryAlias() {
        return this.keyentryAlias;
    }

    @Override
    public Charset getCharacterSetPasswordDecrypt() {
        return this.characterSetPasswordDecrypt;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean isTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean isSafe() {
        return this.safe;
    }

    public static class ConfigurationBuilder {
        private boolean encypt;
        private boolean decypt;
        private boolean hybridEncrypt;
        private boolean hybridDecrypt;
        private boolean zip;
        private boolean unzip;
        private boolean determineEncryptionType;
        private List<String> inFiles;
        private String out;
        private String password;
        private String keyFile;
        private String pKCS12File;
        private String keystorePassword;
        private String keyentryPassword;
        private String keyentryAlias;
        private boolean timeStamp;
        private boolean safe;
        private Charset characterSetPasswordDecrypt;
        private PrivateKey privateKey;
        private PublicKey publicKey;

        public ConfigurationBuilder encypt(boolean encypt) {
            this.encypt = encypt;
            return this;
        }

        public ConfigurationBuilder decypt(boolean decypt) {
            this.decypt = decypt;
            return this;
        }

        public ConfigurationBuilder hybridEncrypt(boolean hybridEncrypt) {
            this.hybridEncrypt = hybridEncrypt;
            return this;
        }

        public ConfigurationBuilder hybridDecrypt(boolean hybridDecrypt) {
            this.hybridDecrypt = hybridDecrypt;
            return this;
        }

        public ConfigurationBuilder zip(boolean zip) {
            this.zip = zip;
            return this;
        }

        public ConfigurationBuilder unzip(boolean unzip) {
            this.unzip = unzip;
            return this;
        }

        public ConfigurationBuilder determineEncryptionType(boolean determineEncryptionType) {
            this.determineEncryptionType = determineEncryptionType;
            return this;
        }

        public ConfigurationBuilder inFiles(List<String> inFiles) {
            this.inFiles = inFiles;
            return this;
        }

        public ConfigurationBuilder inFiles(String inFiles) {
            this.inFiles = Arrays.asList(inFiles.replace(";", ",").split(","));
            return this;
        }

        public ConfigurationBuilder out(String out) {
            this.out = out;
            return this;
        }

        public ConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConfigurationBuilder keyFile(String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        public ConfigurationBuilder pKCS12File(String pKCS12File) {
            this.pKCS12File = pKCS12File;
            return this;
        }

        public ConfigurationBuilder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public ConfigurationBuilder keyentryPassword(String keyentryPassword) {
            this.keyentryPassword = keyentryPassword;
            return this;
        }

        public ConfigurationBuilder keyentryAlias(String keyentryAlias) {
            this.keyentryAlias = keyentryAlias;
            return this;
        }

        public ConfigurationBuilder timestamp(boolean timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public ConfigurationBuilder safe(boolean safe) {
            this.safe = safe;
            return this;
        }

        public ConfigurationBuilder characterSetPasswordDecrypt(Charset characterSetPasswordDecrypt) {
            this.characterSetPasswordDecrypt = characterSetPasswordDecrypt;
            return this;
        }

        public ConfigurationBuilder characterSetPasswordDecryptOfString(String characterSetPasswordDecrypt) {
            if (characterSetPasswordDecrypt != null && !characterSetPasswordDecrypt.equals("")) {
                if (!Charset.isSupported(characterSetPasswordDecrypt)) {
                    throw new IqtigError(Constants.getString("error.param.characterset_pw_decrypt.notparseable", characterSetPasswordDecrypt));
                }
                this.characterSetPasswordDecrypt = Charset.forName(characterSetPasswordDecrypt);
            }
            return this;
        }

        public ConfigurationBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public ConfigurationBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Configuration build() {
            return new ConfigurationImpl(this);
        }
    }
}

