/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.tpacker.cli;

import java.text.DecimalFormat;
import org.iqtig.packer.shared.cli.SystemExitWrapper;
import org.iqtig.packer.shared.error.Errors;
import org.iqtig.packer.shared.error.ValidationErrorException;
import org.iqtig.tpacker.cli.commands.CheckEncryptionTypeCommand;
import org.iqtig.tpacker.cli.commands.DecryptAndUnzipCommand;
import org.iqtig.tpacker.cli.commands.DecryptCommand;
import org.iqtig.tpacker.cli.commands.EncryptCommand;
import org.iqtig.tpacker.cli.commands.HybridDecryptAndUnzipCommand;
import org.iqtig.tpacker.cli.commands.HybridDecryptCommand;
import org.iqtig.tpacker.cli.commands.HybridEncryptCommand;
import org.iqtig.tpacker.cli.commands.MainCommand;
import org.iqtig.tpacker.cli.commands.UnzipCommand;
import org.iqtig.tpacker.cli.commands.ZipAndEncryptCommand;
import org.iqtig.tpacker.cli.commands.ZipAndHybridEncryptCommand;
import org.iqtig.tpacker.cli.commands.ZipCommand;
import org.iqtig.tpacker.cli.error.IqtigError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class TPackerCliApp {
    private static final Logger LOG = LoggerFactory.getLogger(TPackerCliApp.class);
    private final SystemExitWrapper systemExitWrapper;

    public TPackerCliApp(SystemExitWrapper systemExitWrapper) {
        this.systemExitWrapper = systemExitWrapper;
    }

    public void start(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new MainCommand());
        int exitStatusCode = commandLine.addSubcommand((Object)new ZipAndEncryptCommand()).addSubcommand((Object)new ZipAndHybridEncryptCommand()).addSubcommand((Object)new ZipCommand()).addSubcommand((Object)new EncryptCommand()).addSubcommand((Object)new HybridEncryptCommand()).addSubcommand((Object)new DecryptAndUnzipCommand()).addSubcommand((Object)new HybridDecryptAndUnzipCommand()).addSubcommand((Object)new DecryptCommand()).addSubcommand((Object)new HybridDecryptCommand()).addSubcommand((Object)new UnzipCommand()).addSubcommand((Object)new CheckEncryptionTypeCommand()).setExecutionExceptionHandler(this.prepareExecutionExceptionHandler()).setParameterExceptionHandler(this.prepareParameterExceptionHandler(commandLine)).execute(args);
        this.systemExitWrapper.exit(exitStatusCode);
    }

    private CommandLine.IExecutionExceptionHandler prepareExecutionExceptionHandler() {
        return (ex, commandLine1, parseResult) -> {
            if (ex instanceof ValidationErrorException) {
                ValidationErrorException validEx = (ValidationErrorException)((Object)((Object)ex));
                DecimalFormat i = new DecimalFormat("0000000");
                System.err.println("AQ" + i.format(validEx.getId()) + "\t" + validEx.getErrorMessage());
                return 1;
            }
            if (ex instanceof IqtigError) {
                TPackerCliApp.handleError((IqtigError)ex);
            } else if (ex instanceof Exception) {
                System.err.println(Errors.InternalErrorOccured.createInstance().getMessage());
                System.err.println(ex);
                if (ex instanceof RuntimeException && ex.getCause() != null) {
                    System.err.println("Caused By: " + ex.getCause().toString());
                }
                LOG.error("Unbekannter Fehler", (Throwable)ex);
            }
            return 1;
        };
    }

    private CommandLine.IParameterExceptionHandler prepareParameterExceptionHandler(CommandLine commandLine) {
        CommandLine.IParameterExceptionHandler defaultHandler = commandLine.getParameterExceptionHandler();
        return (ex, args1) -> {
            defaultHandler.handleParseException(ex, args1);
            return 1;
        };
    }

    public static void handleError(IqtigError e) {
        for (String error : e.getErrors()) {
            System.err.println(error);
        }
    }
}

